% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tools.R
\name{run_eta}
\alias{run_eta}
\title{Run time estimate for an Odin model run.}
\usage{
run_eta(odin_model, ...)
}
\arguments{
\item{odin_model}{An Odin model \verb{R6 <odin_model>}}

\item{...}{Passed to \verb{$run(...)}}
}
\value{
Estimated run time and resource measured by test run.
}
\description{
Perform test runs of an Odin model with the specified run parameters and
return measured run time for planning large-scale simulation repeats and/or model parameter scans.
}
\examples{
model <- getOdinGen()$continuous_LG$new()
time_hr <- seq(from = 0, to = 24 * 20, by = 1)
run_eta(model, time_hr) # Tell you median run time of simulation
}
