% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/similarity.R
\name{compute_cosine}
\alias{compute_cosine}
\title{Trajectory similarity: Cosine Similarity}
\usage{
compute_cosine(res_mat1, res_mat2)
}
\arguments{
\item{res_mat1}{Trajectory matrix 1, first column must be time while others are states.}

\item{res_mat2}{Trajectory matrix 2, first column must be time while others are states.}
}
\value{
Cosine similarity of the two trajectory, vector with length = number of time steps.
}
\description{
Cosine Similarity is used to characterize how \emph{state direction} of two
trajectory \eqn{\vec{X}(t), \vec{Y}(t)} agree with each other.
It computes cosine of the angle between the two states at each time.
}
\details{
Formula:
\eqn{\mbox{CS}(t^j)=\frac{\Sigma_i X_i(t^j)Y_i(t^j)}{\left\Vert X_i(t^j) \right\Vert \left\Vert Y_i(t^j) \right\Vert}}
}
\examples{
# Perfect alignment (cos=1)
mat1 <- cbind(time = 1:3, state1 = 1:3, state2 = 4:6)
mat2 <- cbind(time = 1:3, state1 = 2:4, state2 = 5:7)
compute_cosine(mat1, mat2)  # c(1, 1, 1)

# Orthogonal vectors (cos=0)
mat3 <- cbind(time = 1:2, state1 = c(1, 0), state2 = c(0, 1))
mat4 <- cbind(time = 1:2, state1 = c(0, 1), state2 = c(1, 0))
compute_cosine(mat3, mat4)  # c(0, 0)

# Opposite direction (cos=-1)
mat5 <- cbind(time = 1:3, state1 = 1:3)
mat6 <- cbind(time = 1:3, state1 = -1:-3)
compute_cosine(mat5, mat6)  # c(-1, -1, -1)
}
