% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Evaluation.r
\name{chiSquareTest}
\alias{chiSquareTest}
\title{Calculates the chi-square statistic}
\usage{
chiSquareTest(cls, mc)
}
\arguments{
\item{cls}{The clickstream object.}

\item{mc}{The Markov chain against which to compare the clickstream data. Please note that the first-order transition matrix is used for performing the chi-square test.}
}
\description{
Calculates the chi-Square statistic, p-value, and degrees of freedom, for the first-order transition matrix of a \code{MarkovChain} object compared with observed state changes.
}
\examples{
clickstreams <- c("User1,h,c,c,p,c,h,c,p,p,c,p,p,o",
                 "User2,i,c,i,c,c,c,d",
                 "User3,h,i,c,i,c,p,c,c,p,c,c,i,d",
                 "User4,c,c,p,c,d")

csf <- tempfile()
writeLines(clickstreams, csf)
cls <- readClickstreams(csf, header = TRUE)
unlink(csf)

mc <- fitMarkovChain(cls)
chiSquareTest(cls, mc)
}
\author{
Theo van Kraay \email{theo.vankraay@hotmail.com}
}
