% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/func.cl.prop.R
\name{func.cl.prop}
\alias{func.cl.prop}
\title{Composite Likelihood Calculation for Spatial Proportional Data}
\usage{
func.cl.prop(vec.yobs, mat.X, mat.lattice, radius, vec.par)
}
\arguments{
\item{vec.yobs}{a vector of observed responses for all N sites.}

\item{mat.X}{regression (design) matrix, including intercepts.}

\item{mat.lattice}{a data matrix containing geographical information of sites. The \emph{i} th row constitutes a set of geographical coordinates.}

\item{radius}{weight radius.}

\item{vec.par}{a vector of parameters consecutively as follows: a cutoff point for latent responses, a vector of covariate parameters, a parameter 'sigmasq' modeling covariance matrix, 0<=sigmasq<=1, and a parameter 'rho' reflecting spatial correlation, abs(rho)<=1.}
}
\value{
\code{func.cl.prop} returns a list of sum of weights, composite log-likelihood, a vector of scores, and a matrix of first-order partial derivatives for \code{vec.par}.
}
\description{
\code{func.cl.prop} calculates the composite log-likelihood for spatial Tobit models.
}
\examples{

# True parameter
alpha <- 4; vec.beta <- c(1, 2, 1, 0, -1); sigmasq <- 0.8; rho <- 0.6; radius <- 5
vec.par <- c(alpha, vec.beta, sigmasq, rho)

# Coordinate matrix
n.lati <- 30; n.long <- 30
n.site <- n.lati * n.long
mat.lattice <- cbind(rep(1:n.lati, n.long), rep(1:n.long, each=n.lati))
mat.dist <- as.matrix(dist(mat.lattice, upper=TRUE, diag=TRUE))
mat.cov <- sigmasq * rho^mat.dist

set.seed(1228)

# Generate regression (design) matrix with intercept
mat.X <- cbind(rep(1, n.site),scale(matrix(rnorm(n.site*(length(vec.beta)-1)),nrow=n.site)))
vec.Z <- t(chol(mat.cov)) \%*\% rnorm(n.site) + mat.X \%*\% vec.beta
vec.epsilon <- diag(sqrt(1-sigmasq), n.site) \%*\% rnorm(n.site)
vec.ylat <- as.numeric(vec.Z + vec.epsilon)

# Convert to the vector of observation
vec.yobs <- func.obs.prop(vec.ylat, alpha=alpha)

# Use func.cl.prop()
ls <- func.cl.prop(vec.yobs, mat.X, mat.lattice, radius, vec.par)
ls$log.lkd
}
\references{
Feng, Xiaoping, Zhu, Jun, Lin, Pei-Sheng, and Steen-Adams, Michelle M. (2014) Composite likelihood Estimation for Models of Spatial Ordinal Data and Spatial Proportional Data with Zero/One values. \emph{Environmetrics} 25(8): 571--583.
}
