% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PlotData.R
\name{PlotData}
\alias{PlotData}
\title{Plot of circular data}
\usage{
PlotData(
  Data,
  drc,
  thr = NULL,
  ylim = NULL,
  pointSize = 4,
  cex.axis = 15,
  cex.lab = 2,
  thrWidth = 2,
  thrColor = "#D45E1A",
  thrLineType = 1,
  ylab = NULL
)
}
\arguments{
\item{Data}{Response variable}

\item{drc}{Directional covariate}

\item{thr}{Threshold values along thetaGrid}

\item{ylim}{Range of values}

\item{pointSize}{Size of points (observations)}

\item{cex.axis}{Graphical parameter}

\item{cex.lab}{Graphical parameter}

\item{thrWidth}{Threshold width}

\item{thrColor}{Threshold colour}

\item{thrLineType}{Graphical parameter}

\item{ylab}{y-axis label}
}
\value{
Plot of circular data, possibly including a threshold.
}
\description{
Plot of circular data
}
\examples{
data(HsSP)
data(drc)

PlotData(Data=HsSP, drc=drc, thr=NULL, pointSize=1, cex.axis=15, cex.lab=2,
         thrWidth=2)

data(thresholdExampleML) # loads threshold example

PlotData(Data=HsSP, drc=drc, thr=thresholdExampleML, pointSize=1, cex.axis=15,
         cex.lab=2, thrWidth=2)
}
