% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/load_parc.R
\name{load_parc}
\alias{load_parc}
\title{Load a parcellation included in \code{ciftiTools}}
\usage{
load_parc(
  name = c("Schaefer_100", "Schaefer_400", "Schaefer_1000", "Yeo_7", "Yeo_17")
)
}
\arguments{
\item{name}{The name of the parcellation to load:
\describe{
\item{\code{"Schaefer_100"}:}{   (2018) 100 parcels based on the "local-global" approach.}
\item{\code{"Schaefer_400"}:}{   (2018) 400 parcels based on the "local-global" approach.}
\item{\code{"Schaefer_1000"}:}{   (2018) 1000 parcels based on the "local-global" approach.}
\item{\code{"Yeo_7"}:}{   (2011) 7 networks based on fcMRI clustering. Networks are further divided into 51 components.}
\item{\code{"Yeo_17"}:}{   (2011) 17 networks based on fcMRI clustering. Networks are further divided into 114 components.}
}

\code{NULL} (default) will load the first choice, where applicable. This
argument will affect the indices, colors, and names of each parcel, but not
the parcel boundaries.}
}
\value{
The parcellation as a dlabel \code{"xifti"} with one column. Each key
represents one unique parcel.
}
\description{
Load a parcellation included in \code{ciftiTools}.
}
\details{
When using these parcellations, please cite the corresponding paper(s):

\enumerate{
\item{Yeo, B. T. T. et al. The organization of the human cerebral cortex estimated by intrinsic functional connectivity. J Neurophysiol 106, 1125-1165 (2011).}
\item{Schaefer, A. et al. Local-Global Parcellation of the Human Cerebral Cortex from Intrinsic Functional Connectivity MRI. Cereb Cortex 28, 3095-3114 (2018).}
\item{Kong, R. et al. Individual-Specific Areal-Level Parcellations Improve Functional Connectivity Prediction of Behavior. Cerebral Cortex (2021+) doi:10.1093/cercor/bhab101.}
}

Note that the Schaefer parcels have been matched to networks from Kong (2021+).
}
\seealso{
Other reading: 
\code{\link{as.xifti}()},
\code{\link{info_cifti}()},
\code{\link{load_surf}()},
\code{\link{read_cifti}()},
\code{\link{read_surf}()},
\code{\link{read_xifti2}()}

Other parcellation-related: 
\code{\link{apply_parc}()},
\code{\link{load_sub_parc}()},
\code{\link{parc_add_subcortex}()},
\code{\link{parc_borders}()},
\code{\link{parc_vals_to_xifti}()}
}
\concept{parcellation-related}
\concept{reading}
