% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Event.R
\name{Event}
\alias{Event}
\title{Create a survival or competing-risks response}
\usage{
Event(time, event, allowed = getOption("cifmodeling.allowed", c(0, 1, 2)))
}
\arguments{
\item{time}{Numeric vector of follow-up times (non-negative).}

\item{event}{Integer (0=censor, 1,2,...) or a character/factor vector whose levels
are numeric codes "0","1","2",... for competing events.}

\item{allowed}{Numeric vector of acceptable event codes.}
}
\value{
An object of class \code{"Event"} (a 2-column matrix) with columns \code{time}, \code{event}.
}
\description{
A lightweight response constructor used in \code{cifcurve()} and \code{polyreg()}
to pass survival and competing-risks data via a model formula.
}
\section{Lifecycle}{

\lifecycle{stable}
}

\examples{
## event: 0=censor, 1=primary, 2=competing
data(diabetes.complications)
output <- polyreg(
  nuisance.model = Event(t, epsilon) ~ +1,
  exposure = "fruitq1",
  data = diabetes.complications,
  effect.measure1 = "RR",
  effect.measure2 = "RR",
  time.point = 8,
  outcome.type = "competing-risk"
)

}
\seealso{
\code{\link[=polyreg]{polyreg()}} for log-odds product modeling of CIFs; \code{\link[=cifcurve]{cifcurve()}} for KM/AJ estimators; \code{\link[=cifplot]{cifplot()}} for display of a CIF; \code{\link[=cifpanel]{cifpanel()}} for display of multiple CIFs; \link[ggsurvfit:ggsurvfit]{ggsurvfit::ggsurvfit}, \link[patchwork:patchwork-package]{patchwork::patchwork} and \link[modelsummary:modelsummary]{modelsummary::modelsummary} for display helpers.
}
