% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/clean-data.R
\name{summarize_counts}
\alias{summarize_counts}
\title{Summarize chromosome counts from API call}
\usage{
summarize_counts(counts)
}
\arguments{
\item{counts}{A 'chrom.counts' object inherited from \code{\link{chrom_counts}}.}
}
\value{
A \code{data.frame} containing the resolved binomial, the count type (gametophytic or sporophytic), the counts, the inferred gametophytic count (for sporophytic records) and the number of records supporting each count.
}
\description{
This function processes and cleans the data returned from the API call for use in downstream analysis.
}
\details{
The results from the API call are a bit messy and difficult to use for downstream analyses. This function cleans up the data in three ways. First, it combines aggregates and summarizes all records from each species. Second, many of the counts are combined with text characters (e.g., \code{"#-#"}, \code{"c.#"}, and \code{"#, #, #"}. This function uses regular expressions to pull out all and any numeric values from these strings. Third, some of the records are gametophytic (n) counts and others are from sporophytes (2n); the function simply divides the sporophytic counts in half so that all measurements are on a common scale.

IMPORTANT: Use this function with caution. Parsing the counts programmatically may be useful but it may generate erroneous results in some cases if input is in an odd format. For example, if the count is \code{"#+-#"}, the function will return both the first and second \code{#} as valid counts . Given the creativity(?) of researchers in entering data, it is hard to predict all possible ways that the counts may be represented. Therefore, some manual checking will probably be necessary.
}
\examples{
\dontrun{

## Get all counts for genus Castilleja
res <- chrom_counts("Castilleja", "genus")

## summarize the results
summarize_counts(res)

}
}
