% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/egt03.R
\docType{data}
\name{egt03_main}
\alias{egt03_main}
\alias{egt03_pre}
\alias{egt03_post}
\alias{egt03}
\title{\code{EGT03} Shift Table of ECG Interval Data - Baseline versus Minimum or Maximum Post-Baseline.}
\format{
An object of class \code{chevron_t} of length 1.
}
\usage{
egt03_main(
  adam_db,
  arm_var = "ACTARMCD",
  summaryvar = "BNRIND",
  splitvar = "ANRIND",
  visitvar = "AVISIT",
  page_var = "PARAMCD",
  ...
)

egt03_pre(adam_db, ...)

egt03_post(tlg, prune_0 = FALSE, ...)

egt03
}
\arguments{
\item{adam_db}{(\code{list} of \code{data.frames}) object containing the \code{ADaM} datasets}

\item{arm_var}{(\code{character}) the arm variables used for row split, typically \code{"ACTARMCD"}.}

\item{summaryvar}{(\code{character}) variables to be analyzed, typically \code{"BNRIND"}. Labels of the corresponding columns
are used as subtitles.}

\item{splitvar}{(\code{character}) variables to be analyzed, typically \code{"ANRIND"}. Labels of the corresponding columns are
used as subtitles.}

\item{visitvar}{(\code{string}) typically \code{"AVISIT"} or user-defined visit incorporating \code{"ATPT"}.}

\item{page_var}{(\code{string}) variable name prior to which the row split is by page.}

\item{...}{not used.}

\item{tlg}{(\code{TableTree}, \code{Listing} or \code{ggplot}) object typically produced by a \code{main} function.}

\item{prune_0}{(\code{flag}) remove 0 count rows}
}
\value{
the main function returns an \code{rtables} object.

the preprocessing function returns a \code{list} of \code{data.frame}.

the postprocessing function returns an \code{rtables} object or an \code{ElementaryTable} (null report).
}
\description{
The \code{EGT03} Table entries provide the number of patients by baseline assessment and minimum or maximum post-baseline
assessment. Percentages are based on the total number of patients in a treatment group. Baseline is the patient's
last observation prior to initiation of study drug.
}
\details{
\itemize{
\item \code{ADEG} data are subsetted to contain only "POST-BASELINE MINIMUM"/"POST-BASELINE MAXIMUM" visit
according to the preprocessing.
\item Percentages are based on the total number of patients in a treatment group.
\item Split columns by Analysis Reference Range Indicator, typically \code{ANRIND}.
\item Does not include a total column by default.
\item Sorted  based on factor level.
}
}
\section{Functions}{
\itemize{
\item \code{egt03_main()}: Main TLG function

\item \code{egt03_pre()}: Preprocessing

\item \code{egt03_post()}: Postprocessing

}}
\note{
\itemize{
\item \code{adam_db} object must contain an \code{adeg} table with a \code{"ACTARMCD"} column as well as columns specified in
\code{summaryvar} and \code{splitvar}.
}
}
\examples{
library(dunlin)

proc_data <- log_filter(syn_data, PARAMCD == "HR", "adeg")
run(egt03, proc_data)
}
\keyword{datasets}
