% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/as.R
\name{as.character.checkglobalsg}
\alias{as.character.checkglobalsg}
\title{Cast to character}
\usage{
\method{as.character}{checkglobalsg}(x, pattern, ...)
}
\arguments{
\item{x}{object inheriting from class \code{"checkglobalsg"}.}

\item{pattern}{an optional \link{regular expression}.  Only names
matching \code{pattern} are returned. \code{\link{glob2rx}} can be
used to convert wildcard patterns to regular expressions.}

\item{...}{additional arguments to configure the output:
\itemize{
\item \code{all.names}, a logical value.  If \code{TRUE}, all object names are returned.
If \code{FALSE}, names which begin with a \samp{.} are omitted. Defaults to \code{TRUE}.
\item \code{sorted}, a logical value indicating if the function/variable names should be sorted alphabetically.
Defaults to \code{TRUE}.
}}
}
\value{
a character vector similar to \code{\link{as.character.checkglobals}}.
}
\description{
Cast an S3-object of class \code{"checkglobalsg"} to a character vector.
}
\examples{
## R-package from folder
chk <- checkglobals(
  pkg = system.file(
    "unit_tests", "pkg", "testpkg",
    package = "checkglobals"
  )
)
as.character(chk$globals)
}
\seealso{
\code{\link{as.character.checkglobals}}
}
