% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/chameleon.R
\name{distinct_colors}
\alias{distinct_colors}
\title{Pick a number of distinct colors.}
\usage{
distinct_colors(
  n,
  minimal_saturation = 33,
  minimal_lightness = 20,
  maximal_lightness = 80
)
}
\arguments{
\item{n}{The requested (positive) number of colors.}

\item{minimal_saturation}{Exclude colors whose saturation (\code{hypot(a, b)} in CIELAB color
space) is less than this value (by default, 33).}

\item{minimal_lightness}{Exclude colors whose lightnes (\code{l} in CIELAB color space) is less
than this value (by default, 20).}

\item{maximal_lightness}{Exclude colors whose lightnes (\code{l} in CIELAB color space) is more
than this value (by default, 80).}
}
\value{
A list with two elements, \code{name} containing the color names and \code{lab}
        containing a matrix with a row per color and three columns containing the \code{l},
        \code{a} and \code{b} coordinates of each color.
}
\description{
This ensures all colors are distinct by packing the (visible part) of the CIELAB color space
with the needed number of spheres, and using their centers to generate the colors.
}
\examples{
chameleon::distinct_colors(8)
}
