% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/carx_plots.R
\name{plot.carx}
\alias{plot.carx}
\title{Plot a fitted \code{carx} object}
\usage{
\method{plot}{carx}(x, FUN = identity, xAxisVar = NULL, xlab = "Index",
  ylab = "Response", ...)
}
\arguments{
\item{x}{a fitted \code{carx} object.}

\item{FUN}{an optional function to be applied to the transform the responses before plotting.
This is useful for plotting the data on the original scale if the fitted \code{carx} object is based on
transformed responses. For instance, if the \code{carx} object was fitted with log transformed responses,
setting \code{FUN} to exp renders the original response data to be plotted. Default = \code{NULL}.}

\item{xAxisVar}{an optional vector to be plotted as the x variable. Default =
\code{NULL} corresponds to doing a time series plot.}

\item{xlab}{the label of the x axis. Default = "Index".}

\item{ylab}{the label of the y axis. Default = "Response".}

\item{...}{other parameters supplied to the generic function \code{plot}.}
}
\value{
None. A plot will be displayed.
}
\description{
\code{plot.carx} plots a fitted \code{carx} object.
}
\details{
The y axis will be the values related to the response.
If the fitted object contains the data and censored  information in a \code{cenTS} object,
the function will take advantage of the plot function for a \code{cenTS} object and superimpose the plot of the fitted values.
Otherwise, the plot function will try to produce a plot similar to the previous case, while the x axis can be supplied by the user through \code{xAxisVar}, which must be ordinal and increasing.
}
\examples{

#case 1: plot with cenTS object in the object, note that the x-axis is in date.
dat = carxSimCenTS(nObs=100,seed=0)
mdl <- carx(y~X1+X2-1,data=dat, p=2, CI.compute = FALSE)
#use default settings
plot(mdl)

#case 2: plot without cenTS object in the object, note that the x-axis is a vector of numbers.
dat = carxSim(nObs=100,seed=0)
mdl <- carx(y=dat$y, x=dat[,c("X1","X2")], ci=dat$ci, lcl=dat$lcl, ucl=dat$ucl, p=2)
#or simply call
mdl <- carx(y~X1+X2-1,data=dat, p=2, CI.compute = FALSE)
plot(mdl)
}
