% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/arml.R
\name{ARml}
\alias{ARml}
\title{Autoregressive forecasting using various Machine Learning models.}
\usage{
ARml(
  y,
  max_lag = 5,
  xreg = NULL,
  caret_method = "cubist",
  metric = "RMSE",
  pre_process = NULL,
  cv = TRUE,
  cv_horizon = 4,
  initial_window = NULL,
  fixed_window = FALSE,
  verbose = TRUE,
  seasonal = TRUE,
  K = frequency(y)/2,
  tune_grid = NULL,
  lambda = NULL,
  BoxCox_method = c("guerrero", "loglik"),
  BoxCox_lower = -1,
  BoxCox_upper = 2,
  BoxCox_biasadj = FALSE,
  BoxCox_fvar = NULL,
  allow_parallel = FALSE,
  calibrate = TRUE,
  calibration_horizon = NULL,
  n_cal_windows = NULL,
  ...
)
}
\arguments{
\item{y}{A univariate time series object.}

\item{max_lag}{Maximum value of lag.}

\item{xreg}{Optional. A numerical vector or matrix of external regressors,
which must have the same number of rows as y.
(It should not be a data frame.).}

\item{caret_method}{A string specifying which classification or
regression model to use.
Possible values are found using names(getModelInfo()).
A list of functions can also be passed for a custom model function.
See \url{https://topepo.github.io/caret/} for details.}

\item{metric}{A string that specifies what summary metric will be used to
select the optimal model. See \code{?caret::train}.}

\item{pre_process}{A string vector that defines a pre-processing of the
predictor data.
Current possibilities are "BoxCox", "YeoJohnson", "expoTrans", "center",
"scale", "range",
"knnImpute", "bagImpute", "medianImpute", "pca", "ica" and "spatialSign".
The default is no pre-processing.
See preProcess and trainControl on the procedures and how to adjust them.
Pre-processing code is only designed to work when x is a simple matrix or
data frame.}

\item{cv}{Logical, if \code{cv = TRUE} model selection will be done via
cross-validation. If \code{cv = FALSE} user need to provide a specific model
via \code{tune_grid} argument.}

\item{cv_horizon}{The number of consecutive values in test set sample.}

\item{initial_window}{The initial number of consecutive values in each
training set sample.}

\item{fixed_window}{Logical, if FALSE, all training samples start at 1.}

\item{verbose}{A logical for printing a training log.}

\item{seasonal}{Boolean. If \code{seasonal = TRUE} the fourier terms will be
used for modeling seasonality.}

\item{K}{Maximum order(s) of Fourier terms}

\item{tune_grid}{A data frame with possible tuning values.
The columns are named the same as the tuning parameters.
Use getModelInfo to get a list of tuning parameters for each model or
see \url{https://topepo.github.io/caret/available-models.html}.
(NOTE: If given, this argument must be named.)}

\item{lambda}{BoxCox transformation parameter. If \code{lambda = NULL}
If \code{lambda = "auto"}, then the transformation parameter lambda is chosen
using \code{\link[forecast]{BoxCox.lambda}}.}

\item{BoxCox_method}{\code{\link[forecast]{BoxCox.lambda}} argument.
Choose method to be used in calculating lambda.}

\item{BoxCox_lower}{\code{\link[forecast]{BoxCox.lambda}} argument.
Lower limit for possible lambda values.}

\item{BoxCox_upper}{\code{\link[forecast]{BoxCox.lambda}} argument.
Upper limit for possible lambda values.}

\item{BoxCox_biasadj}{\code{\link[forecast]{InvBoxCox}} argument.
Use adjusted back-transformed mean for Box-Cox transformations.
If transformed data is used to produce forecasts and fitted values,
a regular back transformation will result in median forecasts.
If biasadj is TRUE, an adjustment will be made to produce mean
forecasts and fitted values.}

\item{BoxCox_fvar}{\code{\link[forecast]{InvBoxCox}} argument.
Optional parameter required if biasadj=TRUE.
Can either be the forecast variance, or a list containing the interval level,
and the corresponding upper and lower intervals.}

\item{allow_parallel}{If a parallel backend is loaded and available,
should the function use it?}

\item{calibrate}{Logical. If TRUE, performs rolling-origin calibration to
compute horizon-specific conformal prediction intervals. This produces
properly calibrated intervals that widen with forecast horizon (trumpet shape).
Default is TRUE.}

\item{calibration_horizon}{Maximum forecast horizon for calibration.
If NULL (default), uses \code{2 * frequency(y)} for seasonal data or 10
for non-seasonal data.}

\item{n_cal_windows}{Number of rolling windows for calibration.
If NULL (default), automatically determined based on data length (max 50).}

\item{...}{Ignored.}
}
\value{
A list class of forecast containing the following elemets
\itemize{
\item x : The input time series
\item method : The name of the forecasting method as a character string
\item mean : Point forecasts as a time series
\item lower : Lower limits for prediction intervals
\item upper : Upper limits for prediction intervals
\item level : The confidence values associated with the prediction intervals
\item model : A list containing information about the fitted model
\item newx : A matrix containing regressors
\item calibration : Horizon-specific conformal calibration scores (if calibrate=TRUE)
}
}
\description{
Autoregressive forecasting using various Machine Learning models.
}
\examples{

library(caretForecast)

train_data <- window(AirPassengers, end = c(1959, 12))

test <- window(AirPassengers, start = c(1960, 1))

ARml(train_data, caret_method = "lm", max_lag = 12) -> fit

forecast(fit, h = length(test)) -> fc

autoplot(fc) + autolayer(test)

accuracy(fc, test)

}
\author{
Resul Akay
}
