\name{sbfControl}
\alias{sbfControl}
\title{
Control Object for Selection By Filtering (SBF)
}
\description{
Controls the execution of models with simple filters for feature selection
}
\usage{
sbfControl(functions = NULL, 
           method = "boot", 
           saveDetails = FALSE, 
           number = ifelse(method == "cv", 10, 25), 
           verbose = TRUE, 
           returnResamp = "all", 
           p = 0.75, 
           index = NULL, 
           workers = 1, 
           computeFunction = lapply, 
           computeArgs = NULL)
}
\arguments{
  \item{functions}{a list of functions for model fitting, prediction and variable filtering (see Details below)}
  \item{method}{The external resampling method: \code{boot}, \code{cv},
    \code{LOOCV} or  \code{LGOCV} (for repeated training/test splits}
  \item{number}{Either the number of folds or number of resampling iterations}
  \item{saveDetails}{a logical to save the predictions and variable importances from the selection process}
  \item{verbose}{a logical to print a log for each external resampling iteration}
  \item{returnResamp}{A character string indicating how much of the resampled summary metrics should be saved. Values can be ``all'' or ``none''}
  \item{p}{For leave-group out cross-validation: the training percentage}
  \item{index}{a list with elements for each external resampling iteration. Each list element is the sample rows used for training at that iteration.}
  \item{workers}{an integer that specifies how many machines/processors will be used}
  \item{computeFunction}{a function that is \code{\link[base]{lapply}} or emulates \code{lapply}. It must have arguments \code{X}, \code{FUN} and \code{...}. \code{computeFunction} can be used to build models in parallel. See the examples in \code{\link{sbf}}.}
  \item{computeArgs}{Extra arguments to pass into the \code{...} slore in \code{computeFunction}. See the examples in \code{\link{sbf}}.}
}

\details{
Simple filter-based feature selection requires function to be specified for some operations. 

The \code{fit} function builds the model based on the current data set. The arguments for the function must be:
\itemize{
      \item{\code{x}}{ the current training set of predictor data with
            the appropriate subset of variables (i.e. after filtering)}
      \item{\code{y}}{ the current outcome data (either a numeric or 
            factor vector)}
      \item{\code{...}}{ optional arguments to pass to the fit 
            function in the call to \code{sbf}}
}
The function should return a model object that can be used to generate predictions.

The \code{pred} function returns a vector of predictions (numeric or factors) from the current model. The arguments are:
\itemize{
      \item{\code{object}}{ the model generated by the \code{fit} 
            function}
      \item{\code{x}}{ the current set of predictor set for the 
            held-back samples}
}

The \code{filter} function is used to return a logical vector with names for each predictor. The values should be \code{TRUE} for predictors that pass the filter and \code{FALSE} for those that do not. Inputs are:
\itemize{
      \item{\code{x}}{ the  predictors for the training samples}
      \item{\code{y}}{ the current training outcomes}
}
The function should return a named local vector, as previously stated.

Examples of these functions are included in the package: \code{\link{caretSBF}}, \code{\link{lmSBF}}, \code{\link{rfSBF}}, \code{\link{treebagSBF}}, \code{\link{ldaSBF}} and \code{\link{nbSBF}}.

Model details about these functions, including examples, are in the package vignette for feature selection.

}
\value{
a list that echos the specified arguments
}

\author{
Max Kuhn
}

\seealso{
\code{\link{sbf}}, \code{\link{caretSBF}}, \code{\link{lmSBF}}, \code{\link{rfSBF}}, \code{\link{treebagSBF}}, \code{\link{ldaSBF}} and \code{\link{nbSBF}}
}

\keyword{ utilities }
