% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generics_augment.R, R/generics_glance.R,
%   R/generics_tidy.R
\name{augment.feglm}
\alias{augment.feglm}
\alias{augment.felm}
\alias{glance.feglm}
\alias{glance.felm}
\alias{tidy.feglm}
\alias{tidy.felm}
\title{Broom Integration}
\usage{
\method{augment}{feglm}(x, newdata = NULL, ...)

\method{augment}{felm}(x, newdata = NULL, ...)

\method{glance}{feglm}(x, ...)

\method{glance}{felm}(x, ...)

\method{tidy}{feglm}(x, conf_int = FALSE, conf_level = 0.95, ...)

\method{tidy}{felm}(x, conf_int = FALSE, conf_level = 0.95, ...)
}
\arguments{
\item{x}{A fitted model object.}

\item{newdata}{Optional argument to use data different from the data used to
fit the model.}

\item{...}{Additional arguments passed to the method.}

\item{conf_int}{Logical indicating whether to include the confidence
interval.}

\item{conf_level}{The confidence level for the confidence interval.}
}
\value{
A tibble with the respective information for the `augment`, `glance`,
 and `tidy` methods.
}
\description{
The provided `broom` methods do the following:
 1. `augment`: Takes the input data and adds additional columns with the
     fitted values and residuals.
 2. `glance`: Extracts the deviance, null deviance, and the number of
     observations.`
 3. `tidy`: Extracts the estimated coefficients and their standard errors.
}
\examples{
set.seed(123)
trade_2006 <- trade_panel[trade_panel$year == 2006, ]
trade_2006 <- trade_2006[sample(nrow(trade_2006), 500), ]

mod <- fepoisson(
  trade ~ log_dist + lang + cntg + clny | exp_year + imp_year,
  trade_2006
)

broom::augment(mod)
broom::glance(mod)
broom::tidy(mod)

}
