% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SolveTC.R
\name{SolveTC}
\alias{SolveTC}
\title{Modelling of reversible contraception for companion animals}
\usage{
SolveTC(pars = NULL, init = NULL, time = NULL, f.range = NULL,
  s.range = NULL, z.range = NULL, ...)
}
\arguments{
\item{pars}{a named \code{\link{vector}} of length 5. The values are point estimates of the death rate (d), the fertility recovery rate (f), the sterilization rate (s), the proportion of infertile immigrants (z) and the proportion of the death rate compensated by immigration (r). Abreviations in parentheses indicate the names that must be given to the values.}

\item{init}{a named \code{\link{vector}} of length 2, with the total number of fertile (n) and infertile (g) animals.}

\item{time}{time sequence for which output is wanted; the first value of times must be the initial time.}

\item{f.range}{optional sequence (between 0 and 1) with the fertility recovery rates to be simulated.}

\item{s.range}{optional \code{\link{vector}} of length 2, with a range of sterilization rates to be assessed. If given, the rates evaluated are those specified by the argument plus the point estimate given in \code{pars}.}

\item{z.range}{optional \code{\link{vector}} of length 2, with a range of the proportion of infertile immigrants. If given, the rates evaluated are those specified by the argument plus the point estimate given in \code{pars}.}

\item{...}{further arguments passed to \link[deSolve]{ode} function.}
}
\value{
\code{\link{list}}. The first element, \code{name}, is a string with the name of the function, the second element, \code{model}, is the model function. The third, fourth and fifth elements are vectors (\code{pars}, \code{init}, \code{time}, respectively) containing the \code{pars}, \code{init} and \code{time} arguments of the function. The sisxthth element \code{results} is a \code{\link{data.frame}} with up to as many rows as elements in time. The first fourth columns contain the time and the variables: \code{n}, \code{g} and \code{u}. When *.range arguments are given, additional columns contain the variables \code{f}, \code{s} and \code{z}.
}
\description{
System of ordinary differential equations to simulate the effect of reversible contraception in a population at equilibrium, where deaths are compensated by births and net immigration.
}
\examples{
# Parameters and initial conditions.
pars_solvetc <- c(d = 1 / 6, f = 0.5, s = 0.2, 
                   z = 0.2, r = 0.8)

init_solvetc <- c(n = 950, g = 50)

# Solve for point estimates.
solve_tc_pt <- SolveTC(pars = pars_solvetc, 
                      init = init_solvetc, 
                      time = 0:10, method = "rk4")

# Solve for parameter ranges.
solve_tc_rg <- SolveTC(pars = pars_solvetc, 
                      init = init_solvetc, 
                      time = 0:15,
                      f.range = seq(0, 1, 0.1), 
                      s.range = c(0.05, 0.4), 
                      z.range = c(0.05, 0.4),
                      method = "rk4")

}
\references{
\url{http://oswaldosantos.github.io/capm}

Baquero, O. S., Brandao, A. P. D., Amaku, M., & Ferreira, F. (2016). Effectiveness of reversible contraception in dog population management. Acta Scientiae Veterinariae, 44, 01-06.
}
\seealso{
\link[deSolve]{ode}.
}
