% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SampleSystematic.R
\name{SampleSystematic}
\alias{SampleSystematic}
\title{Simple and stratified systematic sampling}
\usage{
SampleSystematic(psu.ssu = NULL, su = NULL, N = NULL, write = FALSE,
  ...)
}
\arguments{
\item{psu.ssu}{\code{\link{data.frame}} with all PSU. First column contains PSU unique identifiers. Second column contains \code{\link{numeric}} PSU sizes. It is used only for the second stage of a two-stage cluster design (see details).}

\item{su}{\code{\link{numeric}} indicating the number of sampling units to be selected. If \code{su} has more than one element, stratified sampling is applied and \code{psu.ssu} is ignored (see details).}

\item{N}{\code{\link{numeric}} indicating the number of sampling units in the population. It is intended for simple or stratified sampling designs and when used, \code{psu.ssu} is ignored (see details).}

\item{write}{logical. If \code{TRUE}, a *.csv file containing the PSU and their SSU is writed in the current working directory.}

\item{...}{further arguments passed to \code{\link{write.table}} function.}
}
\value{
A \code{matrix}. For the second stage in a two-stage cluster sampling, the names of columns are the identifiers of selected psu, coerced by \code{\link{as.character}} to avoid scientific notation in case the identifiers be of \code{\link{class}} \code{\link{numeric}}. The rows correspond to the selected SSU within each PSU. For simple systematic sampling, the rows correspond to the selected sampling units. For stratified sampling, each column represent an strata and the rows correspond to the selected sampling units in each strata.
}
\description{
Select sampling units using simple or stratified systematic samplin. In the context of two-stage cluster sampling, select Secondary Sampling Units (SSU) in one or more Primary Sampling Units (PSU), using systematic sampling.
}
\details{
When \code{N} is defined, \code{psu.ssu} is ignored. If \code{N} has one element, \code{su} must too and the result is a simple systematic selection.  If \code{N} has more than one element, \code{su} must have the same number of elements and each oredered pair represent an strata. Thus, when N has more than one element, the result is a stratified sampling with systematic selection within each strata (see examples).
}
\examples{
data(psu_ssu)

## Two-stage cluster sampling
selected_psu <- SamplePPS(psu.ssu = psu_ssu, psu = 10)

# Take a systematic sampling of 5 SSU within each selected PSU.
SampleSystematic(selected_psu, 5, write = FALSE)

## Simple systematic sampling
SampleSystematic(su = 5, N = 100)

## Stratified systematic sampling
SampleSystematic(su = c("urban" = 50, "rural" = 10),
                 N = c("urban" = 4000, "rural" = 150))
}
\references{
Levy P and Lemeshow S (2008). Sampling of populations: methods and applications, Fourth edition. John Wiley and Sons, Inc.

Baquero, O. S., Marconcin, S., Rocha, A., & Garcia, R. D. C. M. (2018). Companion animal demography and population management in Pinhais, Brazil. Preventive Veterinary Medicine.

\url{http://oswaldosantos.github.io/capm}
}
\seealso{
\code{\link{SamplePPS}}.
}
