% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PlotPopPyramid.R
\name{PlotPopPyramid}
\alias{PlotPopPyramid}
\title{Population PlotPopPyramid}
\usage{
PlotPopPyramid(dat = NULL, age.col = NULL, sex.col = NULL,
  str.col = NULL, str.tip = NULL, x.label = "Count",
  stage.label = "Years", legend.label = "Sterilized",
  inner.color = "LightBlue", outer.color = "DarkRed", label.size = 13)
}
\arguments{
\item{dat}{\code{\link{data.frame}}.}

\item{age.col}{\code{dat} column that has a \code{\link{numeric}} \code{\link{vector}} representing ages or stage categories.}

\item{sex.col}{\code{dat} column that has two unique values representing the sex of individuals (see Details).}

\item{str.col}{\code{dat} column that has two unique values representing the reproductive status of individuals (see Details).}

\item{str.tip}{string with the category of \code{str.col} to place at tip of the bars.}

\item{x.label}{string to be used as a label for the x axis. If undefined, \code{x.label} is equal to "Total" (see Details).}

\item{stage.label}{a string to be used as a label for the ages or stage categories. If undefined, \code{stage.label} is equal to "Years" (see Details).}

\item{legend.label}{a string to be used as a label for the legend. If undefined, \code{legend.label} is equal to "Sterilized".}

\item{inner.color}{any valid specification of a color. When \code{str.col} is not \code{NULL}, \code{inner.color} is the color of inner bars.}

\item{outer.color}{any valid way specification of a color. When \code{str.col} is \code{NULL}, \code{outer.color} is the default color. When \code{str.col} is not \code{NULL}, \code{outer.color} is the outer color of bars.}

\item{label.size}{string to define the font size for labels.}
}
\value{
Two opposed horizontal barplots.
}
\description{
Displays two opposed horizontal barplots (pyramid).
}
\details{
\code{PlotPopPyramid} is mainly intended for companion animals population pyramids, although it can display other types of opposed bar charts.

The bars to the left of the x axis correspond to \code{sort(unique(dat[, sex.col]))[1]}. If \code{str.col} is not \code{NULL}, bars will be stacked, with \code{sort(unique(dat[, str.col]))[1]} as their base.

On the top of the plot, it is displayed the total number of observations of each \code{dat[, sex.col]} unique value. This unique values are used as \code{\link{labels}}.

The legend \code{\link{labels}} are equal to the \code{dat[, str.col]} unique values.

Font size of saved plots is usually different to the font size seen in graphic browsers. Before changing font sizes, see the final result in saved (or preview) plots.
 
Other details of the plot can be modifyed using appropriate functions from \code{ggplot2} package (see examples).
}
\note{
In companion animals population surveys, some age categories might be empty. One difference between \code{PlotPopPyramid} and \code{pryramid.plot} is that the first does not drop empty age categories.
}
\examples{
data(dogs)

PlotPopPyramid(dogs,
               age.col = "age",
               sex.col = "sex",
               str.col = "sterilized")

PlotPopPyramid(dogs,
               age.col = "age",
               sex.col = "sex")

## Merge age categories
pp_age <- cut(c(dogs$age, dogs$age3),
               breaks = c(0, 1, 3, 5, 7, 9, 11, 13, 15,
                          max(c(dogs$age, dogs$age3), na.rm = TRUE)),
               labels = c("<1", "1-3", "3-5", "5-7", "7-9",
                          "9-11", "11-13", "13-15", ">15"),
               include.lowest = TRUE)
pp_sex <- c(dogs$sex, dogs$sex3)
pp_ster <- c(dogs$sterilized, dogs$sterilized3)
pp <- data.frame(age = pp_age, sex = pp_sex, sterilized = pp_ster)

PlotPopPyramid(pp,
              age.col = "age",
              sex.col = "sex",
              str.col = "sterilized")

PlotPopPyramid(pp,
              age.col = "age",
              sex.col = "sex")

}
\references{
Baquero, O. S., Marconcin, S., Rocha, A., & Garcia, R. D. C. M. (2018). Companion animal demography and population management in Pinhais, Brazil. Preventive Veterinary Medicine.

\url{http://oswaldosantos.github.io/capm}
}
