% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/one_singlescanDO.R
\name{one_singlescanDO}
\alias{one_singlescanDO}
\title{Performs marker regression}
\usage{
one_singlescanDO(
  phenotype_vector,
  genotype_mat,
  model_family,
  ref_allele = "A",
  covar_table = NULL,
  run_parallel = FALSE,
  n_cores = 4
)
}
\arguments{
\item{phenotype_vector}{A vector of phenotype values, one entry for each individual.}

\item{genotype_mat}{A matrix of genotype values with individuals in rows and markers 
in columns. Matrix entries contain the probability of the reference allele at each 
position for each individual.}

\item{model_family}{Indicates the model family of the phenotypes. This can be 
either "gaussian" or "binomial".}

\item{ref_allele}{the reference allele from the Cape data_obj}

\item{covar_table}{A matrix of covariates with one row per individual.}

\item{run_parallel}{A logical value indicating whether multiple 
processors should be used}

\item{n_cores}{The number of processors to use if run_parallel is TRUE.}
}
\value{
This function returns the t_statistics for all linear models 
testing the effects of each marker on the phenotype.
}
\description{
This is an internal function called by \code{\link{pairscan_null}}
when generating the null distribution for significance testing. 
To perform permutations, we permute trait values, and then re-do
the singlescan, marker selection, and the pair scan on the permuted
data. This function performs the singlescan on the permuted data.
}
\keyword{internal}
