% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cansim_metadata.R
\name{get_cansim_cube_metadata}
\alias{get_cansim_cube_metadata}
\title{Retrieve table metadata from Statistics Canada API}
\usage{
get_cansim_cube_metadata(cansimTableNumber, type = "overview", refresh = FALSE)
}
\arguments{
\item{cansimTableNumber}{A new or old CANSIM/NDM table number or a vector of table numbers}

\item{type}{Which type of metadata to get, options are "overview", "members", "notes", or "corrections".}

\item{refresh}{Refresh the data from the Statistics Canada API}
}
\value{
a tibble containing the table metadata
}
\description{
Retrieves table metadata given an input table number or vector of table numbers using either the new or old table number format. Patience is suggested as the Statistics Canada API can be very slow. The `list_cansim_tables()` function can be used as an alternative to retrieve a (cached) list of CANSIM tables with (more limited) metadata.
}
\examples{
\dontrun{
get_cansim_cube_metadata("34-10-0013")
}
}
