% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/round_coordinates.R
\name{round_coordinates}
\alias{round_coordinates}
\title{Round coordinates to generalize camera trap locations}
\usage{
round_coordinates(x, digits)
}
\arguments{
\item{x}{Camera Trap Data Package object, as returned by \code{\link[=read_camtrapdp]{read_camtrapdp()}}.}

\item{digits}{Number of decimal places to round coordinates to (\code{1}, \code{2} or
\code{3}).}
}
\value{
\code{x} with chosen \code{coordinatePrecision} in metadata and rounded
coordinates and calculated \code{coordinateUncertainty} in deployments.
}
\description{
Rounds deployment coordinates to a certain number of digits to
fuzzy/generalize camera trap locations.
This function can be used before publishing data in order to protect
sensitive species and/or prevent theft of active cameras.
}
\section{Details}{

Rounding coordinates is a recommended method to generalize sensitive
biodiversity information (see \href{https://docs.gbif.org/sensitive-species-best-practices/master/en/#s-generalization}{Section 4.2}
in Chapman 2020).
Use this function to do so for your data.
Determine the category of sensitivity (see \href{https://docs.gbif.org/sensitive-species-best-practices/master/en/#table-06}{Section 2.2}
in Chapman 2020) and choose the associated number of digits :\tabular{lll}{
   category \tab sensitivity \tab digits \cr
   category 1 \tab extreme \tab (do not publish) \cr
   category 2 \tab high \tab 1 \cr
   category 3 \tab medium \tab 2 \cr
   category 4 \tab low \tab 3 \cr
   not sensitive \tab not sensitive \tab all (do not use this function) \cr
}


The function will:
\enumerate{
\item Set the \code{coordinatePrecision} in the metadata (original values will be
overwritten):\tabular{ll}{
   digits \tab coordinatePrecision \cr
   1 \tab 0.1 \cr
   2 \tab 0.01 \cr
   3 \tab 0.001 \cr
}

\item Round all coordinates in the deployments to the selected number of digits.
\item Update the \code{coordinateUncertainy} (in meters) in the deployments.
This uncertainty is based on the number of digits and the latitude,
following \href{https://docs.gbif.org/georeferencing-best-practices/1.0/en/#table-uncertainty}{Table 3}
in Chapman & Wieczorek 2020:\tabular{lllll}{
   digits \tab 0° latitude \tab 30° latitude \tab 60° latitude \tab 85° latitude \cr
   1 \tab 15691 m \tab 14697 m \tab 12461 m \tab 11211 m \cr
   2 \tab 1570 m \tab 1470 m \tab 1246 m \tab 1121 m \cr
   3 \tab 157 m \tab 147 m \tab 125 m \tab 112 m \cr
}


If a \code{coordinatePrecision} is already present, the function will subtract
the \code{coordinateUncertainty} associated with it before setting a new
uncertainty (e.g. \code{0.001} to \code{0.01} = \verb{original value - 157 + 1570 m}).
If \verb{original value} is \code{NA}, the function will assume the coordinates
were obtained by GPS and set \verb{original value = 30}.
}
}

\examples{
x <- example_dataset()

# Original precision
x$coordinatePrecision

# Original coordinates and uncertainty
deployments(x)[c("latitude", "longitude", "coordinateUncertainty")]

# Round coordinates to 1 digit
x_rounded <- round_coordinates(x, 1)

# Updated coordinatePrecision
x_rounded$coordinatePrecision

# Updated coordinates and uncertainty (original 187 - 147 + 14697 = 14737)
deployments(x_rounded)[c("latitude", "longitude", "coordinateUncertainty")]
}
\seealso{
Other transformation functions: 
\code{\link{merge_camtrapdp}()},
\code{\link{shift_time}()},
\code{\link{update_taxon}()},
\code{\link{write_dwc}()},
\code{\link{write_eml}()}
}
\concept{transformation functions}
