% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.R
\name{plot_effects,commOccu-method}
\alias{plot_effects,commOccu-method}
\alias{plot_effects}
\title{Plot Marginal Effects of Covariates}
\usage{
\S4method{plot_effects}{commOccu}(
  object,
  mcmc.list,
  submodel = "state",
  response = "occupancy",
  draws = 1000,
  outdir,
  level = 0.95,
  keyword_quadratic = "_squared",
  ...
)
}
\arguments{
\item{object}{\code{commOccu} object}

\item{mcmc.list}{mcmc.list. Output of \code{fit} called on a \code{commOccu} object}

\item{submodel}{character. Submodel to get plots for. Can be \code{"det"} (detection submodel) or \code{"state"} (occupancy submodel)}

\item{response}{character. response type on y axis. Only relevant for \code{submodel = "state"}. Default is \code{"occupancy"}, can be set to \code{"abundance"} for Royle-Nichols models}

\item{draws}{integer. Number of draws from the posterior to use when generating the plots. If fewer posterior samples than specified in \code{draws} are available, all posterior samples are used.}

\item{outdir}{character. Directory to save plots to (optional)}

\item{level}{numeric. Probability mass to include in the uncertainty interval.}

\item{keyword_quadratic}{character. A suffix in covariate names in the model that indicates a covariate is a quadratic effect of another covariate which does not carry the suffix in its name (e.g. if the covariate is "elevation", the quadratic covariate would be "elevation_squared").}

\item{...}{additional arguments for \code{\link[ggplot2]{ggsave}} - only relevant if \code{outdir} is defined}
}
\value{
A list of ggplot objects (one list item per covariate).
}
\description{
Plot marginal effect plots (= response curves if covariates are continuous) for all species in a community (multi-species) occupancy model. Takes into account species-specific intercepts (if any). Currently only supports continuous covariates, not categorical covariates.
}
\details{
Users who wish to create their own visualizations can use the data stored in the ggplot output. It is accessed via e.g. \code{output$covariate_name$data}
}
