% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/betaBinomial.R
\name{cnorm.betabinomial}
\alias{cnorm.betabinomial}
\title{Fit a beta-binomial regression model for continuous norming}
\usage{
cnorm.betabinomial(
  age,
  score,
  n = NULL,
  weights = NULL,
  mode = 2,
  alpha = 3,
  beta = 3,
  control = NULL,
  scale = "T",
  plot = T
)
}
\arguments{
\item{age}{A numeric vector of predictor values (e.g., age).}

\item{score}{A numeric vector of response values.}

\item{n}{The maximum score (number of trials in the beta-binomial distribution). If NULL, max(score) is used.}

\item{weights}{A numeric vector of weights for each observation. Default is NULL (equal weights).}

\item{mode}{Integer specifying the mode of the model. Default is 2 (direct modelling of \eqn{\gamma} and \eqn{\beta}).
If set to 1, the model is fitted on the basis of \eqn{\mu} and \eqn{\sigma}, the predicted
mean and standard deviation over age.}

\item{alpha}{Integer specifying the degree of the polynomial for the alpha model.
Default is 3. If mode is set to 1, this parameter is used to specify the degree
of the polynomial for the \eqn{\mu} model.}

\item{beta}{Integer specifying the degree of the polynomial for the beta model. Default is 3.
If mode is set to 1, this parameter is used to specify the degree of the polynomial
for the \eqn{\sigma} model.}

\item{control}{A list of control parameters to be passed to the `optim` function.
If NULL, default values are used, namely control = list(reltol = 1e-8, maxit = 1000)
for mode 1 and control = list(factr = 1e-8, maxit = 1000) for mode 2.}

\item{scale}{Type of norm scale, either "T" (default), "IQ", "z" or a double vector with the mean and standard deviation.}

\item{plot}{Logical indicating whether to plot the model. Default is TRUE.}
}
\value{
A list of class "cnormBetaBinomial" or "cnormBetaBinomial2". In case of mode 2
        containing:
  \item{alpha_est}{Estimated coefficients for the alpha model}
  \item{beta_est}{Estimated coefficients for the beta model}
  \item{se}{Standard errors of the estimated coefficients}
  \item{alpha_degree}{Degree of the polynomial for the alpha model}
  \item{beta_degree}{Degree of the polynomial for the beta model}
  \item{result}{Full result from the optimization procedure}
}
\description{
This function fits a beta-binomial regression model where both the \eqn{\alpha} and \eqn{\beta}
parameters of the beta-binomial distribution are modeled as polynomial functions
of the predictor variable (typically age). Setting mode to 1 fits a beta-binomial
model on the basis of \eqn{\mu} and \eqn{\sigma}, setting it to 2 (default) fits a beta-binomial
model directly on the basis of \eqn{\alpha} and \eqn{\beta}.
}
\details{
The function standardizes the input variables, fits polynomial models for both
the alpha and beta parameters, and uses maximum likelihood estimation to
find the optimal parameters. The optimization is performed using the L-BFGS-B method.
}
\examples{
\dontrun{
# Fit a beta-binomial regression model to the PPVT data
model <- cnorm.betabinomial(ppvt$age, ppvt$raw, n = 228)
summary(model)

# Use weights for post-stratification
marginals <- data.frame(var = c("sex", "sex", "migration", "migration"),
                        level = c(1,2,0,1),
                        prop = c(0.51, 0.49, 0.65, 0.35))
weights <- computeWeights(ppvt, marginals)
model <- cnorm.betabinomial(ppvt$age, ppvt$raw, n = 228, weights = weights)
}
}
