% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/varlse.R, R/print-varlse.R, R/criteria.R,
%   R/member.R
\name{var_lm}
\alias{var_lm}
\alias{print.varlse}
\alias{logLik.varlse}
\alias{AIC.varlse}
\alias{BIC.varlse}
\alias{is.varlse}
\alias{is.bvharmod}
\alias{knit_print.varlse}
\title{Fitting Vector Autoregressive Model of Order p Model}
\usage{
var_lm(
  y,
  p = 1,
  exogen = NULL,
  s = 0,
  include_mean = TRUE,
  method = c("nor", "chol", "qr")
)

\method{print}{varlse}(x, digits = max(3L, getOption("digits") - 3L), ...)

\method{logLik}{varlse}(object, ...)

\method{AIC}{varlse}(object, ...)

\method{BIC}{varlse}(object, ...)

is.varlse(x)

is.bvharmod(x)

\method{knit_print}{varlse}(x, ...)
}
\arguments{
\item{y}{Time series data of which columns indicate the variables}

\item{p}{Lag of VAR (Default: 1)}

\item{exogen}{Exogenous variables}

\item{s}{Lag of exogeneous variables in VARX(p, s). By default, \code{s = 0}.}

\item{include_mean}{Add constant term (Default: \code{TRUE}) or not (\code{FALSE})}

\item{method}{Method to solve linear equation system.
(\code{nor}: normal equation (default), \code{chol}: Cholesky, and \code{qr}: HouseholderQR)}

\item{x}{Any object}

\item{digits}{digit option to print}

\item{...}{not used}

\item{object}{A \code{varlse} object}
}
\value{
\code{var_lm()} returns an object named \code{varlse} \link{class}.
It is a list with the following components:

\describe{
\item{coefficients}{Coefficient Matrix}
\item{fitted.values}{Fitted response values}
\item{residuals}{Residuals}
\item{covmat}{LS estimate for covariance matrix}
\item{df}{Numer of Coefficients}
\item{p}{Lag of VAR}
\item{m}{Dimension of the data}
\item{obs}{Sample size used when training = \code{totobs} - \code{p}}
\item{totobs}{Total number of the observation}
\item{call}{Matched call}
\item{process}{Process: VAR}
\item{type}{include constant term (\code{const}) or not (\code{none})}
\item{design}{Design matrix}
\item{y}{Raw input}
\item{y0}{Multivariate response matrix}
\item{method}{Solving method}
\item{call}{Matched call}
}
It is also a \code{bvharmod} class.
}
\description{
This function fits VAR(p) using OLS method.
}
\details{
This package specifies VAR(p) model as

\deqn{Y_{t} = A_1 Y_{t - 1} + \cdots + A_p Y_{t - p} + c + \epsilon_t}

If \code{include_type = TRUE}, there is constant term.
The function estimates every coefficient matrix.

Consider the response matrix \eqn{Y_0}.
Let \eqn{T} be the total number of sample,
let \eqn{m} be the dimension of the time series,
let \eqn{p} be the order of the model,
and let \eqn{n = T - p}.
Likelihood of VAR(p) has

\deqn{Y_0 \mid B, \Sigma_e \sim MN(X_0 B, I_s, \Sigma_e)}

where \eqn{X_0} is the design matrix,
and MN is \href{https://en.wikipedia.org/wiki/Matrix_normal_distribution}{matrix normal distribution}.

Then log-likelihood of vector autoregressive model family is specified by

\deqn{\log p(Y_0 \mid B, \Sigma_e) = - \frac{nm}{2} \log 2\pi - \frac{n}{2} \log \det \Sigma_e - \frac{1}{2} tr( (Y_0 - X_0 B) \Sigma_e^{-1} (Y_0 - X_0 B)^T )}

In addition, recall that the OLS estimator for the matrix coefficient matrix is the same as MLE under the Gaussian assumption.
MLE for \eqn{\Sigma_e} has different denominator, \eqn{n}.

\deqn{\hat{B} = \hat{B}^{LS} = \hat{B}^{ML} = (X_0^T X_0)^{-1} X_0^T Y_0}
\deqn{\hat\Sigma_e = \frac{1}{s - k} (Y_0 - X_0 \hat{B})^T (Y_0 - X_0 \hat{B})}
\deqn{\tilde\Sigma_e = \frac{1}{s} (Y_0 - X_0 \hat{B})^T (Y_0 - X_0 \hat{B}) = \frac{s - k}{s} \hat\Sigma_e}

Let \eqn{\tilde{\Sigma}_e} be the MLE
and let \eqn{\hat{\Sigma}_e} be the unbiased estimator (\code{covmat}) for \eqn{\Sigma_e}.
Note that

\deqn{\tilde{\Sigma}_e = \frac{n - k}{n} \hat{\Sigma}_e}

Then

\deqn{AIC(p) = \log \det \Sigma_e + \frac{2}{n}(\text{number of freely estimated parameters})}

where the number of freely estimated parameters is \eqn{mk}, i.e. \eqn{pm^2} or \eqn{pm^2 + m}.

Let \eqn{\tilde{\Sigma}_e} be the MLE
and let \eqn{\hat{\Sigma}_e} be the unbiased estimator (\code{covmat}) for \eqn{\Sigma_e}.
Note that

\deqn{\tilde{\Sigma}_e = \frac{n - k}{T} \hat{\Sigma}_e}

Then

\deqn{BIC(p) = \log \det \Sigma_e + \frac{\log n}{n}(\text{number of freely estimated parameters})}

where the number of freely estimated parameters is \eqn{pm^2}.
}
\examples{
# Perform the function using etf_vix dataset
fit <- var_lm(y = etf_vix, p = 2)
class(fit)
str(fit)

# Extract coef, fitted values, and residuals
coef(fit)
head(residuals(fit))
head(fitted(fit))
}
\references{
Lütkepohl, H. (2007). \emph{New Introduction to Multiple Time Series Analysis}. Springer Publishing.

Akaike, H. (1969). \emph{Fitting autoregressive models for prediction}. Ann Inst Stat Math 21, 243-247.

Akaike, H. (1971). \emph{Autoregressive model fitting for control}. Ann Inst Stat Math 23, 163-180.

Akaike H. (1974). \emph{A new look at the statistical model identification}. IEEE Transactions on Automatic Control, vol. 19, no. 6, pp. 716-723.

Akaike H. (1998). \emph{Information Theory and an Extension of the Maximum Likelihood Principle}. In: Parzen E., Tanabe K., Kitagawa G. (eds) Selected Papers of Hirotugu Akaike. Springer Series in Statistics (Perspectives in Statistics). Springer, New York, NY.

Gideon Schwarz. (1978). \emph{Estimating the Dimension of a Model}. Ann. Statist. 6 (2) 461 - 464.
}
\seealso{
\itemize{
\item \code{\link[=summary.varlse]{summary.varlse()}} to summarize VAR model
}
}
