% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/act_collapse.R
\name{act_collapse}
\alias{act_collapse}
\alias{act_collapse.eventlog}
\alias{act_collapse.activitylog}
\alias{act_collapse.grouped_log}
\title{Collapse activity labels of a sub process into a single activity}
\usage{
act_collapse(log, ..., method, eventlog = deprecated())

\method{act_collapse}{eventlog}(
  log,
  ...,
  method = c("entry_points", "consecutive"),
  eventlog = deprecated()
)

\method{act_collapse}{activitylog}(
  log,
  ...,
  method = c("entry_points", "consecutive"),
  eventlog = deprecated()
)

\method{act_collapse}{grouped_log}(
  log,
  ...,
  method = c("entry_points", "consecutive"),
  eventlog = deprecated()
)
}
\arguments{
\item{log}{\code{\link{log}}: Object of class \code{\link{log}} or derivatives (\code{\link{grouped_log}}, \code{\link{eventlog}},
\code{\link{activitylog}}, etc.).}

\item{...}{A series of named character vectors. The activity labels in each vector will be collapsed into one activity with the name of the vector.}

\item{method}{Defines how activities are collapsed: "entry_points" heuristically learns which of the specified activities occur at the start and end of the subprocess and collapses accordingly. "consecutive" collapses consecutive sequences of the activities.}

\item{eventlog}{\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#deprecated}{\figure{lifecycle-deprecated.svg}{options: alt='[Deprecated]'}}}{\strong{[Deprecated]}}; please use \code{log} instead.}
}
\description{
Collapse activity labels of a sub process into a single activity
}
\details{
There are different strategies to collapse activity labels (argument ´method´). The "entry_points" method aims to learn the start and end activities of the sub process, by looking at the first and last activity in each case over the whole log. Subsequently, it will create a new instance of the sub process each time there is an end activity followed by a start activity. This strategy will not take into account other activities happening in the mean time. The "consecutive" method will create an instance each time a new sequence of sub activities is started. This strategy will thus only take into account interruptions of the other activity labels.
}
\section{Methods (by class)}{
\itemize{
\item \code{act_collapse(eventlog)}: Collapse activity labels of a subprocess into a single activity

\item \code{act_collapse(activitylog)}: Collapse activity labels of a subprocess into a single activity

\item \code{act_collapse(grouped_log)}: Collapse activity labels of a subprocess into a single activity

}}
\seealso{
Other Activity processing functions: 
\code{\link{act_recode}()},
\code{\link{act_unite}()}
}
\concept{Activity processing functions}
