% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/adapt_dwd.R
\name{dwd_station_overview}
\alias{dwd_station_overview}
\title{Fetch DWD station overview data}
\usage{
dwd_station_overview(
  station_ids,
  safe = TRUE,
  refresh = FALSE,
  flatten = FALSE,
  flatten_mode = "json"
)
}
\arguments{
\item{station_ids}{Station identifiers.}

\item{safe}{Logical; apply throttling and caching.}

\item{refresh}{Logical; refresh cached responses.}

\item{flatten}{Logical; drop nested list columns.}

\item{flatten_mode}{Flatten strategy for list columns. Use "unnest" to
expand list-columns into multiple rows.}
}
\value{
A tibble with station data.

Includes forecast time columns (\code{forecast_start_time}, \code{forecast1_start_time},
\code{forecast2_start_time}) as POSIXct in Europe/Berlin.
}
\description{
Fetch DWD station overview data
}
\details{
Retrieves station overview data from the DWD App API. Official docs:
https://dwd.api.bund.dev. Station IDs can be looked up via DWD opendata
resources or the API documentation.
}
\examples{
\dontrun{
dwd_station_overview(c("10865", "G005"), flatten = TRUE)
}

}
\seealso{
\code{\link[=dwd_crowd_reports]{dwd_crowd_reports()}} and \code{\link[=dwd_warnings_nowcast]{dwd_warnings_nowcast()}}.
}
