% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/QCplotFuns.R
\name{genes_barplot}
\alias{genes_barplot}
\title{Create a bar plot of expression for selected genes across samples in an experiment}
\usage{
genes_barplot(sub.expression.matrix, log.transformation = TRUE)
}
\arguments{
\item{sub.expression.matrix}{subset of the expression matrix containing only selected
genes}

\item{log.transformation}{whether expression should be shown on log (default) or
linear scale}
}
\value{
The bar plot as a ggplot object.
}
\description{
This function creates a clustered bar plot between all samples in the
expression matrix for the selection of genes.
}
\examples{
expression.matrix.preproc <- as.matrix(read.csv(
  system.file("extdata", "expression_matrix_preprocessed.csv", package = "bulkAnalyseR"), 
  row.names = 1
))[1:500,]

print(genes_barplot(head(expression.matrix.preproc,5)))

}
