% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/list-xyz-tidiers.R
\name{tidy_xyz}
\alias{tidy_xyz}
\alias{xyz_tidiers}
\title{Tidy a(n) xyz object masquerading as list}
\usage{
tidy_xyz(x, ...)
}
\arguments{
\item{x}{A list with component \code{x}, \code{y} and \code{z}, where \code{x} and \code{y} are
vectors and \code{z} is a matrix. The length of \code{x} must equal the number of
rows in \code{z} and the length of \code{y} must equal the number of columns in \code{z}.}

\item{...}{Additional arguments. Not used. Needed to match generic
signature only. \strong{Cautionary note:} Misspelled arguments will be
absorbed in \code{...}, where they will be ignored. If the misspelled
argument has a default value, the default value will be used.
For example, if you pass \code{conf.lvel = 0.9}, all computation will
proceed using \code{conf.level = 0.95}. Additionally, if you pass
\code{newdata = my_tibble} to an \code{\link[=augment]{augment()}} method that does not
accept a \code{newdata} argument, it will use the default value for
the \code{data} argument.}
}
\value{
A \link[tibble:tibble]{tibble::tibble} with vector columns \code{x}, \code{y} and \code{z}.
}
\description{
Broom tidies a number of lists that are effectively S3
objects without a class attribute. For example, \code{\link[stats:optim]{stats::optim()}},
\link[base:svd]{svd()} and \code{\link[akima:interp]{akima::interp()}} produce consistent output, but
because they do not have a class attribute, they cannot be handled by S3
dispatch.

These functions look at the elements of a list and determine if there is
an appropriate tidying method to apply to the list. Those tidiers are
implemented as functions of the form \verb{tidy_<function>} or
\verb{glance_<function>} and are not exported (but they are documented!).

If no appropriate tidying method is found, they throw an error.

xyz lists (lists where \code{x} and \code{y} are vectors of coordinates
and \code{z} is a matrix of values) are typically used by functions such as
\code{\link[graphics:persp]{graphics::persp()}} or \code{\link[graphics:image]{graphics::image()}} and returned
by interpolation functions such as \code{\link[akima:interp]{akima::interp()}}.
}
\examples{

A <- list(x = 1:5, y = 1:3, z = matrix(runif(5 * 3), nrow = 5))
image(A)
tidy(A)
}
\seealso{
\code{\link[=tidy]{tidy()}}, \code{\link[graphics:persp]{graphics::persp()}}, \code{\link[graphics:image]{graphics::image()}},
\code{\link[akima:interp]{akima::interp()}}

Other list tidiers: 
\code{\link{glance_optim}()},
\code{\link{list_tidiers}},
\code{\link{tidy_irlba}()},
\code{\link{tidy_optim}()},
\code{\link{tidy_svd}()}
}
\concept{list tidiers}
