% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/matrix-tidiers.R
\name{sparse_tidiers}
\alias{sparse_tidiers}
\alias{tidy.dgTMatrix}
\alias{tidy.dgCMatrix}
\alias{tidy.sparseMatrix}
\title{Tidy a sparseMatrix object from the Matrix package}
\usage{
\method{tidy}{dgTMatrix}(x, ...)

\method{tidy}{dgCMatrix}(x, ...)

\method{tidy}{sparseMatrix}(x, ...)
}
\arguments{
\item{x}{A Matrix object}

\item{...}{Additional arguments. Not used. Needed to match generic
signature only. \strong{Cautionary note:} Misspelled arguments will be
absorbed in \code{...}, where they will be ignored. If the misspelled
argument has a default value, the default value will be used.
For example, if you pass \code{conf.lvel = 0.9}, all computation will
proceed using \code{conf.level = 0.95}. Additionally, if you pass
\code{newdata = my_tibble} to an \code{\link[=augment]{augment()}} method that does not
accept a \code{newdata} argument, it will use the default value for
the \code{data} argument.}
}
\description{
Tidy a sparseMatrix object from the Matrix package into
a three-column data frame, row, column, and value (with
zeros missing). If there are row names or column names,
use those, otherwise use indices
}
\value{
A \code{\link[tibble:tibble]{tibble::tibble()}} with columns:
  \item{row}{Row ID of the original observation.}
  \item{value}{The value/estimate of the component. Results from data reshaping.}
  \item{column}{Column name in the original matrix.}

}
