% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lmodel2-tidiers.R
\name{tidy.lmodel2}
\alias{tidy.lmodel2}
\alias{lmodel2_tidiers}
\title{Tidy a(n) lmodel2 object}
\usage{
\method{tidy}{lmodel2}(x, ...)
}
\arguments{
\item{x}{A \code{lmodel2} object returned by \code{\link[lmodel2:lmodel2]{lmodel2::lmodel2()}}.}

\item{...}{Additional arguments. Not used. Needed to match generic
signature only. \strong{Cautionary note:} Misspelled arguments will be
absorbed in \code{...}, where they will be ignored. If the misspelled
argument has a default value, the default value will be used.
For example, if you pass \code{conf.lvel = 0.9}, all computation will
proceed using \code{conf.level = 0.95}. Additionally, if you pass
\code{newdata = my_tibble} to an \code{\link[=augment]{augment()}} method that does not
accept a \code{newdata} argument, it will use the default value for
the \code{data} argument.}
}
\value{
A \link[tibble:tibble]{tibble::tibble} within eight rows (one for each term estimated
with each method) and columns:
\itemize{
\item \code{method}: Either OLS/MA/SMA/RMA
\item \code{term}: Either "Intercept" or "Slope"
\item \code{estimate}: Estimated coefficient
\item \code{conf.low}: Lower bound of 95\\% confidence interval
\item \code{conf.high}: Upper bound of 95\\% confidence interval
}
}
\description{
Tidy summarizes information about the components of a model.
A model component might be a single term in a regression, a single
hypothesis, a cluster, or a class. Exactly what tidy considers to be a
model component varies cross models but is usually self-evident.
If a model has several distinct types of components, you will need to
specify which components to return.
}
\details{
There are always only two terms in an \code{lmodel2}: \code{"Intercept"}
and \code{"Slope"}. These are computed by four methods: OLS
(ordinary least squares), MA (major axis), SMA (standard major
axis), and RMA (ranged major axis).
}
\examples{

if (require("lmodel2", quietly = TRUE)) {

  library(lmodel2)
  
  data(mod2ex2)
  Ex2.res <- lmodel2(Prey ~ Predators, data=mod2ex2, "relative", "relative", 99)
  Ex2.res

  tidy(Ex2.res)
  glance(Ex2.res)

  # this allows coefficient plots with ggplot2
  library(ggplot2)
  ggplot(tidy(Ex2.res), aes(estimate, term, color = method)) +
    geom_point() +
    geom_errorbarh(aes(xmin = conf.low, xmax = conf.high)) +
    geom_errorbarh(aes(xmin = conf.low, xmax = conf.high))
}

}
\seealso{
\code{\link[=tidy]{tidy()}}, \code{\link[lmodel2:lmodel2]{lmodel2::lmodel2()}}

Other lmodel2 tidiers: 
\code{\link{glance.lmodel2}()}
}
\concept{lmodel2 tidiers}
