% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stats-smooth.spline-tidiers.R
\name{glance.smooth.spline}
\alias{glance.smooth.spline}
\title{Tidy a(n) smooth.spine object}
\usage{
\method{glance}{smooth.spline}(x, ...)
}
\arguments{
\item{x}{A \code{smooth.spline} object returned from \code{\link[stats:smooth.spline]{stats::smooth.spline()}}.}

\item{...}{Additional arguments. Not used. Needed to match generic
signature only. \strong{Cautionary note:} Misspelled arguments will be
absorbed in \code{...}, where they will be ignored. If the misspelled
argument has a default value, the default value will be used.
For example, if you pass \code{conf.lvel = 0.9}, all computation will
proceed using \code{conf.level = 0.95}. Additionally, if you pass
\code{newdata = my_tibble} to an \code{\link[=augment]{augment()}} method that does not
accept a \code{newdata} argument, it will use the default value for
the \code{data} argument.}
}
\value{
A one-row \link[tibble:tibble]{tibble::tibble} with columns:

\item{spar}{smoothing parameter}
\item{lambda}{choice of lambda corresponding to \code{spar}}
\item{df}{equivalent degrees of freedom}
\item{crit}{minimized criterion}
\item{pen.crit}{penalized criterion}
\item{cv.crit}{cross-validation score}
}
\description{
Tidy summarizes information about the components of a model.
A model component might be a single term in a regression, a single
hypothesis, a cluster, or a class. Exactly what tidy considers to be a
model component varies cross models but is usually self-evident.
If a model has several distinct types of components, you will need to
specify which components to return.
}
\seealso{
\code{\link[=augment]{augment()}}, \code{\link[stats:smooth.spline]{stats::smooth.spline()}}

Other smoothing spline tidiers: \code{\link{augment.smooth.spline}}
}
\concept{smoothing spline tidiers}
