% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mclust_tidiers.R
\name{mclust_tidiers}
\alias{augment.Mclust}
\alias{glance.Mclust}
\alias{mclust_tidiers}
\alias{tidy.Mclust}
\title{Tidying methods for Mclust objects}
\usage{
\method{tidy}{Mclust}(x, ...)

\method{augment}{Mclust}(x, data, ...)

\method{glance}{Mclust}(x, ...)
}
\arguments{
\item{x}{Mclust object}

\item{...}{extra arguments, not used}

\item{data}{Original data (required for \code{augment})}
}
\value{
All tidying methods return a data.frame without rownames, whose
structure depends on the method chosen.

\code{tidy} returns one row per component, with 
  \item{component}{A factor describing the cluster from 1:k
  (or 0:k in presence of a noise term in x)}
  \item{size}{The size of each component}
  \item{proportion}{The mixing proportion of each component}
  \item{variance}{In case of one-dimensional and spherical models,
  the variance for each component, omitted otherwise. NA for noise component}
  \item{mean}{The mean for each component. In case of two- or more dimensional models,
  a column with the mean is added for each dimension. NA for noise component}

\code{augment} returns the original data with two extra columns:
  \item{.class}{The class assigned by the Mclust algorithm}
  \item{.uncertainty}{The uncertainty associated with the classification}

\code{glance} returns a one-row data.frame with the columns
  \item{model}{A character string denoting the model at which the optimal BIC occurs}
  \item{n}{The number of observations in the data}
  \item{G}{The optimal number of mixture components}
  \item{BIC}{The optimal BIC value}
  \item{logLik}{The log-likelihood corresponding to the optimal BIC}
  \item{df}{The number of estimated parameters}
  \item{hypvol}{The hypervolume parameter for the noise component if required,
  otherwise set to NA}
}
\description{
These methods summarize the results of Mclust clustering into three
tidy forms. \code{tidy} describes the size, mixing probability, mean
and variabilty of each class, \code{augment} adds the class assignments and
their probabilities to the original data, and
\code{glance} summarizes the model parameters of the clustering.
}
\examples{

library(dplyr)
library(ggplot2)
library(mclust)

set.seed(2016)
centers <- data.frame(cluster=factor(1:3), size=c(100, 150, 50),
                      x1=c(5, 0, -3), x2=c(-1, 1, -2))
points <- centers \%>\% group_by(cluster) \%>\%
 do(data.frame(x1=rnorm(.$size[1], .$x1[1]),
               x2=rnorm(.$size[1], .$x2[1]))) \%>\%
 ungroup()

m = Mclust(points \%>\% dplyr::select(x1, x2))

tidy(m)
head(augment(m, points))
glance(m)

}
\seealso{
\code{\link[mclust]{Mclust}}
}

