% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/aaa02_broadcast_casting.R
\name{aaa02_broadcast_casting}
\alias{aaa02_broadcast_casting}
\alias{broadcast_casting}
\title{Details on Casting Functions}
\description{
'broadcast' provides several "casting" functions. \cr
These can facility complex forms of broadcasting that would normally not be possible. \cr
But these "casting" functions also have their own merit, beside empowering complex broadcasting. \cr
\cr
The following casting functions are available:
\itemize{
\item \link{acast}: \cr
casts group-based subsets of an array into a new dimension. \cr
Useful for, for example, performing \bold{grouped} broadcasted operations. \cr
\item \link{cast_hier2dim}: \cr
casts a nested/hierarchical list into a dimensional list (i.e. array of type \code{list}). \cr
Useful because one cannot broadcast through nesting, but one \bold{can} broadcast along dimensions.
\item \link{cast_dim2hier}: \cr
casts a dimensional list into a nested/hierarchical list; the opposite of \link{cast_hier2dim}. \cr
\item \link{cast_dim2flat}: \cr
casts a dimensional list into a flattened list, but with names that indicate their original dimensional positions. \cr
Mostly useful for printing or summarizing dimensional lists.
\item \link{dropnests}: \cr
drop redundant nesting in lists; mostly used for facilitating the above casting functions. \cr \cr
}
}
\section{Shared Argument \code{in2out}}{

The \link{hier2dim}, \link{cast_hier2dim}, and \link{cast_dim2hier} methods
all have the \code{in2out} argument. \cr
\cr
\cr
\bold{\code{in2out = TRUE}} \cr
By default \code{in2out} is \code{TRUE}. \cr
This means the call \cr
\code{y <- cast_hier2dim(x)} \cr
will cast the elements of the deepest valid depth of \code{x} to the rows of \code{y},
and elements of the depth above that to the columns of \code{y},
and so on until the surface-level elements of \code{x} are cast to the last dimension of \code{y}. \cr
\cr
Similarly, the call \cr
\code{x <- cast_dim2hier(y)} \cr
will cast the rows of \code{y} to the inner most elements of \code{x},
and the columns of \code{y} to one depth above that,
and so on until the last dimension of \code{y} is cast to the surface-level elements of \code{x}. \cr
\cr
Consider the nested list \code{x} with a depth of \code{3},
and the recursive array \code{y} with 3 dimensions,
where their relationship can described as the following code: \cr
\code{y <- cast_hier2dim(x)} \cr
\code{x <- cast_dim2hier(y)}. \cr
Then it holds that: \cr
\code{x[[i]][[j]][[k]]} corresponds to \code{y[[k, j, i]]}, \cr
\eqn{\forall}(\code{i}, \code{j}, \code{k}) , provided \code{x[[i]][[j]][[k]]} exists. \cr
\cr
\cr
\bold{\code{in2out = FALSE}} \cr
If \code{in2out = FALSE}, the call \cr
\code{y <- cast_hier2dim(x, in2out = FALSE)} \cr
will cast the surface-level elements of \code{x} to the rows of \code{y},
and elements of the depth below that to the columns of \code{y},
and so on until the elements of the deepest valid depth of \code{x} are cast to the last dimension of \code{y}. \cr
\cr
Similarly, the call \cr
\code{x <- cast_dim2hier(y, in2out = FALSE)} \cr
will cast the rows of \code{y} to the surface-level elements of \code{x},
and the columns of \code{y} to one depth below that,
and so on until the last dimension of \code{y} is cast to the inner most elements of \code{x}. \cr
\cr
Consider the nested list \code{x} with a depth of \code{3},
and the recursive array \code{y} with 3 dimensions,
where their relationship can described with the following code: \cr
\code{y <- cast_hier2dim(x, in2out = FALSE)} \cr
\code{x <- cast_dim2hier(y, in2out = FALSE)}. \cr
Then it holds that : \cr
\code{x[[i]][[j]][[k]]} corresponds to \code{y[[i, j, k]]}, \cr
\eqn{\forall}(\code{i}, \code{j}, \code{k}) , provided \code{x[[i]][[j]][[k]]} exists. \cr \cr
}

