% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/package-auth.R
\name{db_wsid}
\alias{db_wsid}
\title{Fetch Databricks Workspace ID}
\usage{
db_wsid(profile = default_config_profile())
}
\arguments{
\item{profile}{Profile to use when fetching from environment variable
(e.g. \code{.Renviron}) or \code{.databricksfg} file}
}
\value{
databricks workspace ID
}
\description{
Workspace ID, optionally specified to make connections pane more powerful.
Specified as an environment variable \code{DATABRICKS_WSID}.
\code{.databrickscfg} will be searched if \code{db_profile} and \code{use_databrickscfg} are set or
if Posit Workbench managed OAuth credentials are detected.

Refer to \href{https://docs.databricks.com/aws/en/dev-tools/auth}{api authentication docs}
}
\details{
The behaviour is subject to change depending if \code{db_profile} and
\code{use_databrickscfg} options are set.
\itemize{
\item \code{use_databrickscfg}: Boolean (default: \code{FALSE}), determines if credentials
are fetched from profile of \code{.databrickscfg} or \code{.Renviron}
\item \code{db_profile}: String (default: \code{NULL}), determines profile used.
\code{.databrickscfg} will automatically be used when Posit Workbench managed OAuth credentials are detected.
}

See vignette on authentication for more details.
}
\seealso{
Other Databricks Authentication Helpers: 
\code{\link{db_host}()},
\code{\link{db_read_netrc}()},
\code{\link{db_token}()}
}
\concept{Databricks Authentication Helpers}
