% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vector-search.R
\name{db_vs_indexes_query}
\alias{db_vs_indexes_query}
\title{Query a Vector Search Index}
\usage{
db_vs_indexes_query(
  index,
  columns,
  filters_json,
  query_vector = NULL,
  query_text = NULL,
  score_threshold = 0,
  query_type = c("ANN", "HYBRID"),
  num_results = 10,
  host = db_host(),
  token = db_token(),
  perform_request = TRUE
)
}
\arguments{
\item{index}{Name of vector search index}

\item{columns}{Column names to include in response}

\item{filters_json}{JSON string representing query filters, see details.}

\item{query_vector}{Numeric vector. Required for direct vector access index
and delta sync index using self managed vectors.}

\item{query_text}{Required for delta sync index using model endpoint.}

\item{score_threshold}{Numeric score threshold for the approximate nearest
neighbour (ANN) search. Defaults to 0.0.}

\item{query_type}{One of \code{ANN} (default) or \code{HYBRID}}

\item{num_results}{Number of returns to return (default: 10).}

\item{host}{Databricks workspace URL, defaults to calling \code{\link[=db_host]{db_host()}}.}

\item{token}{Databricks workspace token, defaults to calling \code{\link[=db_token]{db_token()}}.}

\item{perform_request}{If \code{TRUE} (default) the request is performed, if
\code{FALSE} the httr2 request is returned \emph{without} being performed.}
}
\description{
Query a Vector Search Index
}
\details{
You cannot specify both \code{query_vector} and \code{query_text} at the same time.

\code{filter_jsons} examples:
\itemize{
\item \code{'{"id <": 5}'}: Filter for id less than 5
\item \code{'{"id >": 5}'}: Filter for id greater than 5
\item \code{'{"id <=": 5}'}: Filter for id less than equal to 5
\item \code{'{"id >=": 5}'}: Filter for id greater than equal to 5
\item \code{'{"id": 5}'}: Filter for id equal to 5
\item \code{'{"id": 5, "age >=": 18}'}: Filter for id equal to 5 and age greater than
equal to 18
}

\code{filter_jsons} will convert attempt to use \code{jsonlite::toJSON} on any
non character vectors.

Refer to docs for \href{https://docs.databricks.com/en/generative-ai/create-query-vector-search.html#use-filters-on-queries}{Vector Search}.
}
\examples{
\dontrun{
db_vs_indexes_sync(
  index = "myindex",
  columns = c("id", "text"),
  query_vector = c(1, 2, 3)
)
}

}
\seealso{
Other Vector Search API: 
\code{\link{db_vs_endpoints_create}()},
\code{\link{db_vs_endpoints_delete}()},
\code{\link{db_vs_endpoints_get}()},
\code{\link{db_vs_endpoints_list}()},
\code{\link{db_vs_indexes_create}()},
\code{\link{db_vs_indexes_delete}()},
\code{\link{db_vs_indexes_delete_data}()},
\code{\link{db_vs_indexes_get}()},
\code{\link{db_vs_indexes_list}()},
\code{\link{db_vs_indexes_query_next_page}()},
\code{\link{db_vs_indexes_scan}()},
\code{\link{db_vs_indexes_sync}()},
\code{\link{db_vs_indexes_upsert_data}()},
\code{\link{delta_sync_index_spec}()},
\code{\link{direct_access_index_spec}()},
\code{\link{embedding_source_column}()},
\code{\link{embedding_vector_column}()}
}
\concept{Vector Search API}
