% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/jobs.R
\name{db_jobs_run_now}
\alias{db_jobs_run_now}
\title{Trigger A New Job Run}
\usage{
db_jobs_run_now(
  job_id,
  jar_params = list(),
  notebook_params = list(),
  python_params = list(),
  spark_submit_params = list(),
  host = db_host(),
  token = db_token(),
  perform_request = TRUE
)
}
\arguments{
\item{job_id}{The canonical identifier of the job.}

\item{jar_params}{Named list. Parameters are used to invoke the main
function of the main class specified in the Spark JAR task. If not specified
upon run-now, it defaults to an empty list. \code{jar_params} cannot be specified
in conjunction with \code{notebook_params}.}

\item{notebook_params}{Named list. Parameters is passed to the notebook
and is accessible through the \code{dbutils.widgets.get} function. If not specified
upon run-now, the triggered run uses the job’s base parameters.}

\item{python_params}{Named list. Parameters are passed to Python file as
command-line parameters. If specified upon run-now, it would overwrite the
parameters specified in job setting.}

\item{spark_submit_params}{Named list. Parameters are passed to spark-submit
script as command-line parameters. If specified upon run-now, it would
overwrite the parameters specified in job setting.}

\item{host}{Databricks workspace URL, defaults to calling \code{\link[=db_host]{db_host()}}.}

\item{token}{Databricks workspace token, defaults to calling \code{\link[=db_token]{db_token()}}.}

\item{perform_request}{If \code{TRUE} (default) the request is performed, if
\code{FALSE} the httr2 request is returned \emph{without} being performed.}
}
\description{
Trigger A New Job Run
}
\details{
\itemize{
\item \verb{*_params} parameters cannot exceed 10,000 bytes when serialized to JSON.
\item \code{jar_params} and \code{notebook_params} are mutually exclusive.
}
}
\seealso{
Other Jobs API: 
\code{\link{db_jobs_create}()},
\code{\link{db_jobs_delete}()},
\code{\link{db_jobs_get}()},
\code{\link{db_jobs_list}()},
\code{\link{db_jobs_reset}()},
\code{\link{db_jobs_runs_cancel}()},
\code{\link{db_jobs_runs_delete}()},
\code{\link{db_jobs_runs_export}()},
\code{\link{db_jobs_runs_get}()},
\code{\link{db_jobs_runs_get_output}()},
\code{\link{db_jobs_runs_list}()},
\code{\link{db_jobs_runs_submit}()},
\code{\link{db_jobs_update}()}
}
\concept{Jobs API}
