% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/clusters.R
\name{db_cluster_list}
\alias{db_cluster_list}
\title{List Clusters}
\usage{
db_cluster_list(host = db_host(), token = db_token(), perform_request = TRUE)
}
\arguments{
\item{host}{Databricks workspace URL, defaults to calling \code{\link[=db_host]{db_host()}}.}

\item{token}{Databricks workspace token, defaults to calling \code{\link[=db_token]{db_token()}}.}

\item{perform_request}{If \code{TRUE} (default) the request is performed, if
\code{FALSE} the httr2 request is returned \emph{without} being performed.}
}
\description{
List Clusters
}
\details{
Return information about all pinned clusters, active clusters, up to 150 of
the most recently terminated all-purpose clusters in the past 30 days, and up
to 30 of the most recently terminated job clusters in the past 30 days.

For example, if there is 1 pinned cluster, 4 active clusters, 45 terminated
all-purpose clusters in the past 30 days, and 50 terminated job clusters in
the past 30 days, then this API returns:
\itemize{
\item the 1 pinned cluster
\item 4 active clusters
\item All 45 terminated all-purpose clusters
\item The 30 most recently terminated job clusters
}
}
\seealso{
Other Clusters API: 
\code{\link{db_cluster_create}()},
\code{\link{db_cluster_edit}()},
\code{\link{db_cluster_events}()},
\code{\link{db_cluster_get}()},
\code{\link{db_cluster_list_node_types}()},
\code{\link{db_cluster_list_zones}()},
\code{\link{db_cluster_perm_delete}()},
\code{\link{db_cluster_pin}()},
\code{\link{db_cluster_resize}()},
\code{\link{db_cluster_restart}()},
\code{\link{db_cluster_runtime_versions}()},
\code{\link{db_cluster_start}()},
\code{\link{db_cluster_terminate}()},
\code{\link{db_cluster_unpin}()},
\code{\link{get_and_start_cluster}()},
\code{\link{get_latest_dbr}()}
}
\concept{Clusters API}
