% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/04-show.R
\name{br_show_forest_ggstatsplot}
\alias{br_show_forest_ggstatsplot}
\title{Show a forest plot with \code{ggstatsplot} interface}
\usage{
br_show_forest_ggstatsplot(breg, idx = 1, ...)
}
\arguments{
\item{breg}{A regression object with results (must pass \code{assert_breg_obj_with_results()}).}

\item{idx}{Length-1 vector. Index or name (focal variable) of the model.
This is different from \code{idx} in \link{br_show_forest_ggstats}, only one model is supported
to visualized here, so only length-1 vector is supported as \code{idx}.}

\item{...}{Arguments passing to \code{\link[ggstatsplot:ggcoefstats]{ggstatsplot::ggcoefstats()}} excepts \code{x}.}
}
\value{
A plot
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#stable}{\figure{lifecycle-stable.svg}{options: alt='[Stable]'}}}{\strong{[Stable]}}

Provides an interface to visualize the model results with \href{https://github.com/IndrajeetPatil/ggstatsplot/}{\strong{ggstatsplot}} package.
}
\examples{
if (rlang::is_installed("ggstats")) {
  m <- br_pipeline(mtcars,
    y = "mpg",
    x = colnames(mtcars)[2:4],
    x2 = "vs",
    method = "gaussian"
  )
  br_show_forest_ggstatsplot(m)
}

}
\seealso{
Other br_show: 
\code{\link{br_show_fitted_line}()},
\code{\link{br_show_fitted_line_2d}()},
\code{\link{br_show_forest}()},
\code{\link{br_show_forest_ggstats}()},
\code{\link{br_show_risk_network}()},
\code{\link{br_show_table}()},
\code{\link{br_show_table_gt}()}
}
\concept{br_show}
