% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ORI.R
\name{logLik.bqrorOR1}
\alias{logLik.bqrorOR1}
\alias{logLik}
\title{Extractor function for log marginal likelihood for OR1 model}
\usage{
\method{logLik}{bqrorOR1}(object, y, x, b0, B0, d0, D0, tune, p, REML,...)
}
\arguments{
\item{object}{bqrorOR1 object from which a log-likelihood value, or a contribution to a log-likelihood value, is extracted.}

\item{y}{observed ordinal outcomes, column vector of size \eqn{(n x 1)}.}

\item{x}{covariate matrix of size \eqn{(n x k)} including a column of ones with or without column names.}

\item{b0}{prior mean for \eqn{\beta}.}

\item{B0}{prior covariance matrix for \eqn{\beta}}

\item{d0}{prior mean for \eqn{\delta}.}

\item{D0}{prior covariance matrix for \eqn{\delta}.}

\item{tune}{tuning parameter to adjust MH acceptance rate.}

\item{p}{quantile level or skewness parameter, p in (0,1).}

\item{REML}{an optional logical value. If TRUE the restricted log-likelihood is returned, else, if FALSE, the log-likelihood is returned. Defaults to FALSE.}

\item{...}{ignored}
}
\value{
Returns an object of class logLik for logarithm of marginal likelihood
}
\description{
This function extracts the logarithm of marginal likelihood for OR1 model (ordinal
quantile model with 3 or more outcomes) using bqrorOR1 object from
quantregOR1 modeling.
}
\details{
This function is an extractor function for logarithm of marginal likelihood of OR1 model
from the bqrorOR1 object.
}
\examples{
set.seed(101)
data("data25j4")
y <- data25j4$y
xMat <- data25j4$x
k <- dim(xMat)[2]
J <- dim(as.array(unique(y)))[1]
b0 <- array(rep(0, k), dim = c(k, 1))
B0 <- 10*diag(k)
d0 <- array(0, dim = c(J-2, 1))
D0 <- 0.25*diag(J - 2)
output <- quantregOR1(y = y, x = xMat, b0, B0, d0, D0,
burn = 10, mcmc = 40, p = 0.25, tune = 1, verbose = FALSE)
loglik <- logLik(output, y, xMat, b0, B0 = 10*diag(k), d0,
D0 = D0, tune = 1, p = 0.25, REML = FALSE)
# loglik
#   -554.61

}
\references{
Rahman, M. A. (2016). “Bayesian
Quantile Regression for Ordinal Models.”
Bayesian Analysis, 11(1): 1-24. DOI: 10.1214/15-BA939

Chib, S., and Greenberg, E. (1995). “Understanding the Metropolis-Hastings
Algorithm.” The American Statistician, 49(4): 327-335. DOI: 10.2307/2684568

Chib, S. (1995). “Marginal likelihood from the Gibbs output.” Journal of the American
Statistical Association, 90(432):1313–1321, 1995. DOI: 10.1080/01621459.1995.10476635

Chib, S., and Jeliazkov, I. (2001). “Marginal likelihood from the Metropolis-Hastings output.” Journal of the
American Statistical Association, 96(453):270–281, 2001. DOI: 10.1198/016214501750332848

Greenberg, E. (2012). “Introduction to Bayesian Econometrics.” Cambridge University
Press, Cambridge. DOI: 10.1017/CBO9780511808920
}
\seealso{
\link[NPflow]{mvnpdf}, \link[stats]{dnorm}, \link[stats]{logLik}
Gibbs sampling, Metropolis-Hastings algorithm
}
