% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ORI.R
\name{traceplot_or1}
\alias{traceplot_or1}
\title{Trace plots for ordinal quantile model with more than 3 outcomes}
\usage{
traceplot_or1(beta, delta, burn)
}
\arguments{
\item{beta}{Gibbs draw of \eqn{\beta} vector of dimension \eqn{(k x nsim)}.}

\item{delta}{Gibbs draw of \eqn{\delta}.}

\item{burn}{number of discarded MCMC iterations.}
}
\value{
Returns trace plots for each element of \eqn{\beta}
and \eqn{\delta}.
}
\description{
This function generates trace plots of
MCMC samples for \eqn{(\beta ,\delta)} in the quantile
regression model with more than 3 outcomes.
}
\details{
Trace plot is a visual depiction of the values generated from the markov chain
versus the iteration number.
}
\examples{
set.seed(101)
data("data25j4")
x <- data25j4$x
y <- data25j4$y
k <- dim(x)[2]
J <- dim(as.array(unique(y)))[1]
D0 <- 0.25*diag(J - 2)
output <- quantreg_or1(y = y,x = x, B0 = 10*diag(k), D0 = D0,
mcmc = 50, p = 0.25, tune = 1, display = FALSE)
mcmc <- 50
beta <- output$beta
delta <- output$delta
traceplot_or1(beta, delta, round(0.25*mcmc))

}
\references{
Rahman, M. A. (2016). “Bayesian
Quantile Regression for Ordinal Models.”
Bayesian Analysis, 11(1): 1-24. DOI: 10.1214/15-BA939
}
\seealso{
MCMC simulations
}
