% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Covariate_effect.R
\name{covariate_effect}
\alias{covariate_effect}
\title{Covariate Effect for Bayesian Quantile Regression for Ordinal Models}
\usage{
covariate_effect(model, y, x, mod_x, p)
}
\arguments{
\item{model}{outcome of the ODR I (quan_regg3) model.}

\item{y}{dependent variable i.e. ordinal outcome values.}

\item{x}{covariate matrix of dimension \eqn{(n x k)} including a column of ones.}

\item{mod_x}{matrix x with suitable modification to an independent variable including a column of ones.}

\item{p}{quantile level or skewness parameter, p in (0,1).}
}
\value{
Returns a list with components:
\itemize{
\item{\code{avgdiff_prob}: }{a vector with change in predicted
probabilities for each outcome category.}
}
}
\description{
This function estimates the change in probability of different ordinal
outcomes due to change in an independent variable, marginalized over
the parameters and values of other covariates
}
\details{
Function estimates the covariate effect of the change in an independent
variable. The effect is marginalized over other parameters and values of other covariates.
This function can only be used for ordinal models with more than 3 outcomes. Function uses
the output of ODR I model to compute the covariate effect.
}
\examples{
 set.seed(101)
 data("data25j4")
 x <- data25j4$x
 y <- data25j4$y
 p <- 0.25
 ans <- quan_regg3(y, x, mc = 50, p, 0.1)
 mod_x <- x
 mod_x[,3] <- mod_x[,3] + 0.02
 res <- covariate_effect(ans, y, x, mod_x, p)

 # avgdiff_prob
 #   -4.156752e-03  4.945857e-05 -4.134889e-03  4.085430e-03

}
\references{
Rahman, M. A. (2016). “Bayesian
Quantile Regression for Ordinal Models.”
Bayesian Analysis, 11(1): 1-24.

Jeliazkov, I., Graves, J., and Kutzbach, M. (2008). “Fitting and Comparison of Models
for Multivariate Ordinal Outcomes.” Advances in Econometrics: Bayesian Econo-
metrics, 23: 115–156.
}
