% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/result_formatting.R
\name{format_boinet_results}
\alias{format_boinet_results}
\title{Format BOIN-ET Results for Reporting}
\usage{
format_boinet_results(
  boinet_result,
  output_format = c("list", "tidy", "gt_ready")
)
}
\arguments{
\item{boinet_result}{Result object from any boinet function (boinet,
tite.boinet, gboinet, tite.gboinet)}

\item{output_format}{Character string specifying output format:
\itemize{
\item "list" - Returns original result unchanged
\item "tidy" - Returns tidy data frames for analysis
\item "gt_ready" - Returns formatted gt tables for reporting
}}
}
\value{
Results in specified format
}
\description{
Converts boinet simulation results into various formats optimized for
analysis and reporting workflows. This is the MAIN new function.
}
\examples{
\dontrun{
# Run simulation first
result <- tite.boinet(
  n.dose = 4, start.dose = 1, size.cohort = 3, n.cohort = 10,
  toxprob = c(0.05, 0.15, 0.25, 0.40),
  effprob = c(0.15, 0.30, 0.45, 0.60),
  phi = 0.30, delta = 0.60, n.sim = 100
)

# Format for different uses
original <- format_boinet_results(result, "list")
tidy_data <- format_boinet_results(result, "tidy")
report_tables <- format_boinet_results(result, "gt_ready")

# Use formatted results
print(tidy_data$operating_characteristics)
print(report_tables$oc_table)
}
}
