% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/enhanced_functions.R
\name{extract_operating_characteristics}
\alias{extract_operating_characteristics}
\title{Extract Operating Characteristics in Tidy Format}
\usage{
extract_operating_characteristics(boinet_result)
}
\arguments{
\item{boinet_result}{Result object from boinet functions (tite.boinet,
tite.gboinet, boinet, gboinet)}
}
\value{
A tibble with columns: dose_level, toxicity_prob, efficacy_prob,
n_patients, selection_prob, selection_pct
}
\description{
Converts boinet simulation results into a tidy data frame suitable for
analysis and reporting.
}
\examples{
\dontrun{
# Run BOIN-ET simulation
result <- tite.boinet(
  n.dose = 4, start.dose = 1, size.cohort = 3, n.cohort = 10,
  toxprob = c(0.05, 0.15, 0.25, 0.40),
  effprob = c(0.15, 0.30, 0.45, 0.60),
  phi = 0.30, delta = 0.60, n.sim = 100
)

# Extract in tidy format
oc_data <- extract_operating_characteristics(result)
print(oc_data)
}
}
