% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bn2.R
\name{bn2}
\alias{bn2}
\alias{bn2gbn}
\alias{bn2ci}
\title{Integration with \code{bn.fit} objects from \code{bnlearn}}
\usage{
bn2gbn(bnfit)

bn2ci(bnfit)
}
\arguments{
\item{bnfit}{object of class \code{bn.fit}.}
}
\value{
The function \code{bn2gbn} returns an object of class \code{GBN} consisting of a list with entries:
\itemize{
\item \code{order}: An ordering of the nodes according to the graph.
\item \code{mean}: The mean vector of the Gaussian distribution.
\item \code{covariance}: The covariance matrix of the Gaussian distribution.
}

The function \code{bn2ci} returns an object of class \code{CI} consisting of the same list as \code{GBN}, but with the additional entry \code{cond_ind}. \code{cond_ind} is a list where each entry consists of \code{A}, \code{B} and \code{C} corresponding to the conditional independence statements \code{A} independent of \code{B} given \code{C} embedded by the network.
}
\description{
Functions that transform an object of class \code{bn.fit} and \code{bn.fit.gnet} (a Gaussian Bayesian network) to objects of class \code{GBN} or \code{CI}.
}
