% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/blandr.draw.r
\name{blandr.draw}
\alias{blandr.draw}
\title{Bland-Altman drawing function for R}
\usage{
blandr.draw(method1, method2, method1name = "Method 1",
  method2name = "Method 2",
  plotTitle = "Bland-Altman plot for comparison of 2 methods",
  sig.level = 0.95, LoA.mode = 1, annotate = FALSE, ciDisplay = TRUE,
  ciShading = TRUE, normalLow = FALSE, normalHigh = FALSE,
  lowest_y_axis = FALSE, highest_y_axis = FALSE, point_size = 0.8,
  overlapping = FALSE, plotter = "ggplot", x.plot.mode = "means",
  y.plot.mode = "difference", plotProportionalBias = FALSE,
  plotProportionalBias.se = TRUE, assume.differences.are.normal = TRUE)
}
\arguments{
\item{method1}{A list of numbers.}

\item{method2}{A list of numbers.}

\item{method1name}{(Optional) Plotting name for 1st method, default 'Method 1'}

\item{method2name}{(Optional) Plotting name for 2nd method, default 'Method 2'}

\item{plotTitle}{(Optional) Title name, default 'Bland-Altman plot for comparison of 2 methods'}

\item{sig.level}{(Optional) Two-tailed significance level. Expressed from 0 to 1. Defaults to 0.95.}

\item{LoA.mode}{(Optional) Switch to change how accurately the limits of agreement (LoA) are calculated from the bias and its standard deviation. The default is LoA.mode=1 which calculates LoA with the more accurate 1.96x multiplier. LoA.mode=2 uses the 2x multiplier which was used in the original papers. This should really be kept at default, except to double check calculations in older papers.}

\item{annotate}{(Optional) TRUE/FALSE switch to provides annotations to plot, default=FALSE}

\item{ciDisplay}{(Optional) TRUE/FALSE switch to plot confidence intervals for bias and limits of agreement, default=TRUE}

\item{ciShading}{(Optional) TRUE/FALSE switch to plot confidence interval shading to plot, default=TRUE}

\item{normalLow}{(Optional) If there is a normal range, entering a continuous variable will plot a vertical line on the plot to indicate its lower boundary}

\item{normalHigh}{(Optional) If there is a normal range, entering a continuous variable will plot a vertical line on the plot to indicate its higher boundary}

\item{lowest_y_axis}{(Optional) Defaults to NULL If given a continuous variable will use this as the lower boundary of the y axis. Useful if need multiple plots with equivalent y-axes.}

\item{highest_y_axis}{(Optional) Defaults to NULL If given a continuous variable will use this as the upper boundary of the y axis. Useful if need multiple plots with equivalent y-axes.}

\item{point_size}{(Optional) Size of marker for each dot. Default is cex=0.8}

\item{overlapping}{(Optional) TRUE/FALSE switch to increase size of plotted point if multiple values using ggplot's geom_count, deafault=FALSE. Not currently recommend until I can tweak the graphics to make them better}

\item{plotter}{(Optional- default='ggplot') Selects which graphics engine to use to plot the Bland-Altman charts. 2 options are 'ggplot' or 'rplot'. If unknown parameter sent, will default to 'ggplot'}

\item{x.plot.mode}{(Optional) Switch to change x-axis from being plotted by means (="means") or by either 1st method (="method1") or 2nd method (="method2"). Default is "means". Anything other than "means" will switch to default mode.}

\item{y.plot.mode}{(Optional) Switch to change y-axis from being plotted by difference (="difference") or by proportion magnitude of measurements (="proportion"). Default is "difference". Anything other than "proportional" will switch to default mode.}

\item{plotProportionalBias}{(Optional) TRUE/FALSE switch. Plots a proportional bias line. Default is FALSE.}

\item{plotProportionalBias.se}{(Optional) TRUE/FALSE switch. If proportional bias line is drawn, switch to plot standard errors. See stat_smooth for details. Default is TRUE.}

\item{assume.differences.are.normal}{(Optional, not operationally used currently) Assume the difference of means has a normal distribution. Will be used to build further analyses}
}
\description{
Bland-Altman drawing function. Depends on the blandr.statistics function in the package. Will generate a plot via the standard R plotting functions.
}
\note{
Started 2015-11-14

Last update 2015-11-19

Originally designed for LAVAS and CVLA
}
\examples{
# Generates two random measurements
measurement1 <- rnorm(100)
measurement2 <- rnorm(100)

# Generates a plot, with no optional arguments
blandr.draw( measurement1 , measurement2 )

# Generates a plot, using the in-built R graphics
blandr.draw( measurement1 , measurement2 , plotter = 'rplot' )

# Generates a plot, with title changed
blandr.draw( measurement1 , measurement2 , plotTitle = 'Bland-Altman example plot' )

# Generates a plot, with title changed, and confidence intervals off
blandr.draw( measurement1 , measurement2 , plotTitle = 'Bland-Altman example plot' ,
ciDisplay = FALSE , ciShading = FALSE )

}
\author{
Deepankar Datta <deepankardatta@nhs.net>
}
