% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/offset.R
\name{offset}
\alias{offset}
\alias{add.bizdays}
\title{Offsets the given \code{dates} by \code{n} business days}
\usage{
offset(dates, n, cal)

add.bizdays(dates, n, cal)
}
\arguments{
\item{dates}{dates to be offset}

\item{n}{the amount of business days to offset}

\item{cal}{the calendar's name}
}
\value{
\code{Date} objects offset by the amount of days defined.
}
\description{
Returns the given \code{dates} offset by the given amount of \code{n}
business days.
}
\details{
The argument \code{n} accepts a sequence of integers and if its length
differs from \code{dates}' length, the recycle rule is applied to fulfill the
gap.
}
\section{Date types accepted}{


The argument \code{dates} accepts \code{Date} objects and any
object that returns a valid \code{Date} object when passed through
\code{as.Date}, which include all \code{POSIX*} classes and \code{character}
objects with ISO formatted dates.
}

\section{Recycle rule}{


These arguments handle the recycle rule so a vector of dates and a vector of
numbers can be provided and once those vectors differs in length the recycle
rule is applied.
}

\examples{
create.calendar("Brazil/ANBIMA", holidaysANBIMA, weekdays=c("saturday", "sunday"),
                adjust.from=adjust.next, adjust.to=adjust.previous)
offset("2013-01-02", 5, "Brazil/ANBIMA")

# Once you have a default calendar set, cal does not need to be provided
bizdays.options$set(default.calendar="Brazil/ANBIMA")

dates <- seq(as.Date("2013-01-01"), as.Date("2013-01-05"), by="day")
is.bizday(dates)
offset(dates, 1)

}
