% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/birp.R
\name{birp}
\alias{birp}
\title{Creating a Birp Object}
\usage{
birp(
  data,
  timesOfChange = c(),
  negativeBinomial = FALSE,
  stochastic = FALSE,
  BACI = NULL,
  assumeTrueDetectionProbability = FALSE,
  iterations = 1e+05,
  numBurnin = 10,
  burnin = 1000,
  thinning = 10,
  verbose = TRUE
)
}
\arguments{
\item{data}{A \link{birp_data} object}

\item{timesOfChange}{A numeric or integer vector specifying the times of change}

\item{negativeBinomial}{A boolean indicating if Poisson (default) or negative binomial model should be used}

\item{stochastic}{A boolean indicating if deterministic (default) or stochastic trend model should be used}

\item{BACI}{A matrix specifying the BACI configuration. Each row of the matrix corresponds to a control/intervention group, and each column to an epoch. The very first column specifies the name of the control-intervention group and must match the groups specified in data. The values of the matrix specify which gamma to use for each group and epoch. E.g. BACI = matrix(c("A", "B", 1, 1, 1, 2), nrow = 2) corresponds to a canonical BACI design where the first row represents the control group (A) and the second row represents the intervention group (B)}

\item{assumeTrueDetectionProbability}{A boolean indicating if provided detection probabilities are "true", i.e. meaning that they will be transform to logit and not standardized}

\item{iterations}{The number of MCMC iterations to run}

\item{numBurnin}{The number of burnin cycles to run}

\item{burnin}{The number of MCMC iterations per burnin cycle}

\item{thinning}{Integer value specifying the thinning interval for recording the MCMC trace. Only every \code{thinning}th iteration will be retained (e.g., \code{thinning = 1} records every iteration, \code{thinning = 2} records every second iteration, and so on).}

\item{verbose}{Logical. If \code{FALSE}, the console output is suppressed}
}
\value{
An object of class birp
}
\description{
This function creates a birp object by running the MCMC
}
\examples{
data <- simulate_birp()
est <- birp(data)
}
