% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/FitSecondaryGrowth_class.R
\name{FitSecondaryGrowth}
\alias{FitSecondaryGrowth}
\alias{print.FitSecondaryGrowth}
\alias{plot.FitSecondaryGrowth}
\alias{summary.FitSecondaryGrowth}
\alias{residuals.FitSecondaryGrowth}
\alias{coef.FitSecondaryGrowth}
\alias{vcov.FitSecondaryGrowth}
\alias{deviance.FitSecondaryGrowth}
\alias{fitted.FitSecondaryGrowth}
\alias{predict.FitSecondaryGrowth}
\alias{logLik.FitSecondaryGrowth}
\alias{AIC.FitSecondaryGrowth}
\title{FitSecondaryGrowth class}
\usage{
\method{print}{FitSecondaryGrowth}(x, ...)

\method{plot}{FitSecondaryGrowth}(x, y = NULL, ..., which = 1, add_trend = FALSE, add_segment = FALSE)

\method{summary}{FitSecondaryGrowth}(object, ...)

\method{residuals}{FitSecondaryGrowth}(object, ...)

\method{coef}{FitSecondaryGrowth}(object, ...)

\method{vcov}{FitSecondaryGrowth}(object, ...)

\method{deviance}{FitSecondaryGrowth}(object, ...)

\method{fitted}{FitSecondaryGrowth}(object, ...)

\method{predict}{FitSecondaryGrowth}(object, newdata = NULL, ...)

\method{logLik}{FitSecondaryGrowth}(object, ...)

\method{AIC}{FitSecondaryGrowth}(object, ..., k = 2)
}
\arguments{
\item{x}{An instance of FitSecondaryGrowth.}

\item{...}{ignored}

\item{y}{ignored.}

\item{which}{A numeric with the type of plot. 1 for obs versus predicted (default),
2 for gamma curve}

\item{add_trend}{Whether to add a trend line (only for which=2)}

\item{add_segment}{Whether to join the observed and fitted points (only for which=2)}

\item{object}{an instance of FitSecondaryGrowth}

\item{newdata}{A tibble describing the environmental conditions as in
\code{\link[=fit_secondary_growth]{fit_secondary_growth()}}. If \code{NULL}, it uses the same
conditions as for model fitting (default).}

\item{k}{penalty for the parameters (k=2 by default)}
}
\description{
The \code{FitSecondaryGrowth} class contains a model fitted to a set of growth rates
gathered under a variety of static conditions.
Its constructor is \code{\link[=fit_secondary_growth]{fit_secondary_growth()}}.

It is a subclass of list with the items:
\itemize{
\item fit_results: object returned by \code{\link[=modFit]{modFit()}}.
\item secondary_model: secondary model fitted to the data.
\item mu_opt_fit: estimated growth rate under optimum conditions.
\item data: data used for the fit.
\item transformation: type of transformation of \code{mu} for the fit.
}
}
\section{Methods (by generic)}{
\itemize{
\item \code{print(FitSecondaryGrowth)}: print of the model

\item \code{plot(FitSecondaryGrowth)}: plots to evaluate the goodness of the fit.

\item \code{summary(FitSecondaryGrowth)}: statistical summary of the fit.

\item \code{residuals(FitSecondaryGrowth)}: vector of model residuals.

\item \code{coef(FitSecondaryGrowth)}: vector of fitted model parameters.

\item \code{vcov(FitSecondaryGrowth)}: variance-covariance matrix of the model, estimated
as 1/(0.5*Hessian)

\item \code{deviance(FitSecondaryGrowth)}: deviance of the model.

\item \code{fitted(FitSecondaryGrowth)}: vector of fitted values.

The fitted values are returned in the same scale as the one
used for the fitting (sqrt, log or none).

\item \code{predict(FitSecondaryGrowth)}: vector of model predictions.

\item \code{logLik(FitSecondaryGrowth)}: loglikelihood of the model

\item \code{AIC(FitSecondaryGrowth)}: Akaike Information Criterion

}}
