% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/flanking.R
\name{upstream}
\alias{upstream}
\alias{downstream}
\alias{flanking}
\title{Find flanking features.}
\usage{
upstream(query, subject, n = 5, include_key = "all", exclude_key = "none")

downstream(query, subject, n = 5, include_key = "all",
  exclude_key = "none")

flanking(query, subject, n = 5, include_key = "all", exclude_key = "none")
}
\arguments{
\item{query}{A \code{\linkS4class{gbFeature}} or \code{\linkS4class{gbFeatureTable}}
object.}

\item{subject}{A \code{\linkS4class{gbRecord}} or \code{\linkS4class{gbFeatureTable}}
object within which the n nearest upstream features are found.}

\item{n}{The number of upstream features to be returned.}

\item{include_key}{Which features should be returned. Defaults to
\dQuote{all}.}

\item{exclude_key}{Which feature(s) should be excluded from the search.
Defaults to \dQuote{none}.}
}
\value{
A (list of) \code{\linkS4class{gbFeatureTable}}s.
}
\description{
Find flanking features.
}
\examples{
load(system.file("extdata", "S_cerevisiae_mito.rda", package = "biofiles"))
cytb <- ft(filter(x, product = "^cytochrome b$"))

## find the three nearest upstream neighbor CDS to CYTB 
upstream(cytb, x["CDS"], n = 3)
}
