% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/all-generics.R, R/gbLocation-class.R,
%   R/gbFeature-class.R, R/gbFeatureTable-class.R, R/gbRecord-class.R,
%   R/gbRecordList-class.R
\docType{methods}
\name{strand}
\alias{strand}
\alias{strand<-}
\alias{strand,gbLocation-method}
\alias{strand<-,gbLocation-method}
\alias{strand,gbFeature-method}
\alias{strand<-,gbFeature-method}
\alias{strand,gbFeatureTable-method}
\alias{strand<-,gbFeatureTable-method}
\alias{strand,gbRecord-method}
\alias{strand,gbRecordList-method}
\title{Get or set the strand information of genomic features}
\usage{
strand(x, ...)

strand(x, ...) <- value

\S4method{strand}{gbLocation}(x, join = FALSE)

\S4method{strand}{gbLocation}(x, ...) <- value

\S4method{strand}{gbFeature}(x, join = FALSE)

\S4method{strand}{gbFeature}(x, ...) <- value

\S4method{strand}{gbFeatureTable}(x, join = FALSE)

\S4method{strand}{gbFeatureTable}(x, ...) <- value

\S4method{strand}{gbRecord}(x, join = FALSE)

\S4method{strand}{gbRecordList}(x, join = FALSE)
}
\arguments{
\item{x}{A \code{\linkS4class{gbFeature}}, \code{\linkS4class{gbFeatureTable}},
\code{\linkS4class{gbRecord}}, or \code{\linkS4class{gbRecordList}} object.}

\item{...}{Further arguments passed to methods.}

\item{value}{The strand information to set on \code{x}.}

\item{join}{Join compound genomic locations into a single range.}
}
\value{
An integer vector (or a list thereof) of 1 (plus strand), -1 (minus strand), or
\code{NA}
}
\description{
Get or set the strand information of genomic features
}
\examples{
load(system.file("extdata", "marine_metagenome.rda", package = "biofiles"))

## strand
strand(x)

## `strand<-`
showMethods("strand<-")
}
\seealso{
\code{\link{start}}, \code{\link{end}}, \code{\link{span}}, \code{\link{ranges}}
}
